/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.jes.util;

import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPOutputStream;
import javax.json.JsonObject;
import javax.json.JsonValue;
import net.pincette.json.filter.JacksonGenerator;
import net.pincette.util.Util;
import org.apache.kafka.common.serialization.Serializer;

public class JsonSerializer
implements Serializer<JsonObject> {
    private final CBORFactory factory = CBORFactory.builder().build();

    @Override
    public void close() {
    }

    @Override
    public void configure(Map<String, ?> map, boolean isKey) {
    }

    @Override
    public byte[] serialize(String topic, JsonObject json) {
        return Optional.ofNullable(json).map(this::toCompressedCbor).orElse(null);
    }

    private byte[] toCompressedCbor(JsonObject json) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Util.tryToDoRethrow(() -> new JacksonGenerator(this.factory.createGenerator(new GZIPOutputStream(out))).write((JsonValue)json).close());
        return out.toByteArray();
    }
}

