/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.jes.util;

import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import net.pincette.jes.util.Event;
import net.pincette.jes.util.Href;
import net.pincette.jes.util.Mongo;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;
import net.pincette.mongo.JsonClient;
import net.pincette.mongo.Operator;
import net.pincette.util.Collections;
import net.pincette.util.Pair;
import net.pincette.util.Util;
import org.bson.Document;

public class MongoExpressions {
    private static final String ADDED = "$jes-added";
    private static final String APP_FIELD = "app";
    private static final String CHANGED = "$jes-changed";
    private static final String FIND_ONE_OP = "$jes-findOne";
    private static final String FIND_OP = "$jes-find";
    private static final String FROM = "from";
    private static final String HREF_OP = "$jes-href";
    private static final String ID_FIELD = "id";
    private static final String KEY = "key";
    private static final String NAME_UUID = "$jes-name-uuid";
    private static final String POINTER = "pointer";
    private static final String QUERY_FIELD = "query";
    private static final String REMOVED = "$jes-removed";
    private static final String SCOPE = "scope";
    private static final String TO = "to";
    private static final String TYPE_FIELD = "type";
    private static final String UUID = "$jes-uuid";

    private MongoExpressions() {
    }

    public static Implementation added(JsonValue expression, Features features) {
        return MongoExpressions.changedSimple(expression, features, Event::added);
    }

    public static Implementation changed(JsonValue expression, Features features) {
        Implementation from = Expression.memberFunction(expression, FROM, features);
        Implementation pointer = Expression.memberFunction(expression, POINTER, features);
        Implementation to = Expression.memberFunction(expression, TO, features);
        return (json, vars) -> pointer != null ? MongoExpressions.pointer(pointer, json, vars).map(p -> JsonUtil.createValue(from != null && to != null && Event.changed(json, p, (JsonValue)from.apply(json, vars), (JsonValue)to.apply(json, vars)) || (from == null || to == null) && Event.changed(json, p))).orElse(JsonValue.FALSE) : JsonValue.NULL;
    }

    private static Implementation changedSimple(JsonValue expression, Features features, BiPredicate<JsonObject, String> op) {
        Implementation pointer = Expression.implementation(expression, features);
        return (json, vars) -> MongoExpressions.pointer(pointer, json, vars).map(p -> JsonUtil.createValue(op.test((JsonObject)json, (String)p))).orElse(JsonValue.FALSE);
    }

    public static Operator find(MongoDatabase database, String environment) {
        return (expression, features) -> MongoExpressions.finder(expression, database, environment, MongoExpressions::findArray, features);
    }

    private static CompletionStage<JsonValue> findArray(MongoCollection<Document> collection, JsonStructure query) {
        return JsonUtil.isObject(query) ? JsonClient.find(collection, query.asJsonObject()).thenApply(r -> r.stream().reduce(JsonUtil.createArrayBuilder(), JsonArrayBuilder::add, (b1, b2) -> b1).build()) : JsonClient.aggregate(collection, query.asJsonArray()).thenApply(JsonUtil::from);
    }

    private static CompletionStage<JsonValue> findObject(MongoCollection<Document> collection, JsonStructure query) {
        Function<List, JsonValue> result = list -> list.size() == 1 ? (JsonValue)list.get(0) : JsonValue.NULL;
        return JsonUtil.isObject(query) ? JsonClient.findOne(collection, query.asJsonObject()).thenApply(r -> r.map(JsonValue.class::cast).orElse(JsonValue.NULL)) : JsonClient.aggregate(collection, query.asJsonArray()).thenApply(result);
    }

    public static Operator findOne(MongoDatabase database, String environment) {
        return (expression, features) -> MongoExpressions.finder(expression, database, environment, MongoExpressions::findObject, features);
    }

    private static Implementation finder(JsonValue expression, MongoDatabase database, String environment, BiFunction<MongoCollection<Document>, JsonStructure, CompletionStage<JsonValue>> op, Features features) {
        Implementation app = Expression.memberFunction(expression, APP_FIELD, features);
        Implementation query = Expression.memberFunction(expression, QUERY_FIELD, features);
        Implementation type = Expression.memberFunction(expression, TYPE_FIELD, features);
        return (json, vars) -> app != null && query != null && type != null ? Optional.of((JsonValue)query.apply(json, vars)).filter(value -> JsonUtil.isObject(value) || JsonUtil.isArray(value)).flatMap(value -> Util.tryToGetRethrow(() -> (JsonValue)((CompletionStage)op.apply(database.getCollection(Mongo.collection(new Href(MongoExpressions.string(app, json, vars), MongoExpressions.string(type, json, vars)), environment)), (JsonStructure)value)).toCompletableFuture().get())).orElse(JsonValue.NULL) : JsonValue.NULL;
    }

    public static Implementation href(JsonValue expression, Features features) {
        Implementation app = Expression.memberFunction(expression, APP_FIELD, features);
        Implementation id = Expression.memberFunction(expression, ID_FIELD, features);
        Implementation type = Expression.memberFunction(expression, TYPE_FIELD, features);
        return (json, vars) -> app != null && type != null ? JsonUtil.createValue(new Href(MongoExpressions.string(app, json, vars), MongoExpressions.string(type, json, vars), MongoExpressions.string(id, json, vars)).path()) : JsonValue.NULL;
    }

    public static Implementation nameUUID(JsonValue expression, Features features) {
        Implementation scope = Expression.memberFunction(expression, SCOPE, features);
        Implementation key = Expression.memberFunction(expression, KEY, features);
        return (json, vars) -> scope != null && key != null ? JsonUtil.createValue(java.util.UUID.nameUUIDFromBytes((JsonUtil.asString((JsonValue)scope.apply(json, vars)).getString() + "#" + JsonUtil.asLong((JsonValue)key.apply(json, vars))).getBytes(StandardCharsets.UTF_8)).toString().toLowerCase()) : JsonValue.NULL;
    }

    public static Map<String, Operator> operators(MongoDatabase database, String environment) {
        return Collections.map(Pair.pair(ADDED, MongoExpressions::added), Pair.pair(CHANGED, MongoExpressions::changed), Pair.pair(FIND_ONE_OP, MongoExpressions.findOne(database, environment)), Pair.pair(FIND_OP, MongoExpressions.find(database, environment)), Pair.pair(HREF_OP, MongoExpressions::href), Pair.pair(NAME_UUID, MongoExpressions::nameUUID), Pair.pair(REMOVED, MongoExpressions::removed), Pair.pair(UUID, (e, f) -> MongoExpressions.uuid()));
    }

    private static Optional<String> pointer(Implementation fn, JsonObject json, Map<String, JsonValue> vars) {
        return Optional.of((JsonValue)fn.apply(json, vars)).filter(JsonUtil::isString).map(JsonUtil::asString).map(JsonString::getString);
    }

    public static Implementation removed(JsonValue expression, Features features) {
        return MongoExpressions.changedSimple(expression, features, Event::removed);
    }

    private static String string(Implementation implementation, JsonObject json, Map<String, JsonValue> variables) {
        return implementation != null ? JsonUtil.asString((JsonValue)implementation.apply(json, variables)).getString() : null;
    }

    public static Implementation uuid() {
        return (json, vars) -> JsonUtil.createValue(java.util.UUID.randomUUID().toString().toLowerCase());
    }
}

