/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.jes.util;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import net.pincette.jes.util.Command;
import net.pincette.jes.util.Event;
import net.pincette.jes.util.Reducer;
import net.pincette.json.JsonUtil;
import net.pincette.util.Collections;

public class Util {
    private static final Set<String> TECHNICAL_FIELDS = Collections.set("_command", "_corr", "_id", "_jwt", "_languages", "_seq", "_test", "_timestamp", "_type");

    private Util() {
    }

    public static Reducer compose(Reducer validator, Reducer reducer) {
        return (command, aggregate) -> ((CompletionStage)validator.apply(command, aggregate)).thenComposeAsync(result -> Command.hasError(result) ? CompletableFuture.completedFuture(result) : (CompletionStage)reducer.apply(command, aggregate));
    }

    public static Optional<String> getUsername(JsonObject json) {
        return JsonUtil.getString(json, "/_jwt/sub");
    }

    public static boolean isJesObject(JsonObject json) {
        return json != null && JsonUtil.getString(json, "/_id").isPresent() && JsonUtil.getString(json, "/_type").isPresent();
    }

    public static boolean isManagedObject(JsonObject json) {
        return Util.isJesObject(json) && JsonUtil.getNumber(json, "/_seq").isPresent();
    }

    public static boolean isManagedObject(JsonObject json, String type, String id) {
        return Util.isManagedObject(json) && type != null && id != null && JsonUtil.getString(json, "/_type").filter(t -> t.equals(type)).isPresent() && JsonUtil.getString(json, "/_id").filter(i -> i.equalsIgnoreCase(id)).isPresent();
    }

    public static Stream<JsonObject> reconstruct(JsonArray events) {
        return Util.reconstruct(events.stream());
    }

    public static Stream<JsonObject> reconstruct(JsonParser events) {
        return Util.reconstruct(net.pincette.json.filter.Util.stream(events));
    }

    public static Stream<JsonObject> reconstruct(Stream<? extends JsonValue> events) {
        return events.filter(JsonUtil::isObject).map(JsonValue::asJsonObject).map(Event.applyEvent());
    }

    public static JsonObjectBuilder removeTechnical(JsonObject json) {
        return TECHNICAL_FIELDS.stream().reduce(JsonUtil.createObjectBuilder(json), JsonObjectBuilder::remove, (b1, b2) -> b1);
    }
}

