/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.Objects;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.util.Pair;
import net.pincette.util.StreamUtil;

public class Jackson {
    private Jackson() {
    }

    public static JsonNode from(JsonValue json) {
        switch (json.getValueType()) {
            case ARRAY: {
                return Jackson.from(json.asJsonArray());
            }
            case FALSE: {
                return JsonNodeFactory.instance.booleanNode(false);
            }
            case NULL: {
                return JsonNodeFactory.instance.nullNode();
            }
            case NUMBER: {
                return Jackson.from(JsonUtil.asNumber(json));
            }
            case OBJECT: {
                return Jackson.from(json.asJsonObject());
            }
            case STRING: {
                return JsonNodeFactory.instance.textNode(JsonUtil.asString(json).getString());
            }
            case TRUE: {
                return JsonNodeFactory.instance.booleanNode(true);
            }
        }
        return null;
    }

    private static ValueNode from(JsonNumber number) {
        return number.isIntegral() ? JsonNodeFactory.instance.numberNode(number.longValue()) : JsonNodeFactory.instance.numberNode(number.bigDecimalValue());
    }

    public static ObjectNode from(JsonObject json) {
        return json.entrySet().stream().map(e -> Pair.pair((String)e.getKey(), Jackson.from((JsonValue)e.getValue()))).filter(pair -> pair.second != null).reduce(JsonNodeFactory.instance.objectNode(), (node, pair) -> (ObjectNode)node.set((String)pair.first, (JsonNode)pair.second), (n1, n2) -> n1);
    }

    public static ArrayNode from(JsonArray json) {
        return json.stream().map(Jackson::from).filter(Objects::nonNull).reduce(JsonNodeFactory.instance.arrayNode(), ArrayNode::add, (n1, n2) -> n1);
    }

    public static JsonValue to(JsonNode json) {
        switch (json.getNodeType()) {
            case ARRAY: {
                return Jackson.to((ArrayNode)json);
            }
            case BOOLEAN: {
                return json.booleanValue() ? JsonValue.TRUE : JsonValue.FALSE;
            }
            case NULL: {
                return JsonValue.NULL;
            }
            case NUMBER: {
                return Jackson.toNumber(json);
            }
            case OBJECT: {
                return Jackson.to((ObjectNode)json);
            }
            case STRING: {
                return JsonUtil.createValue(json.textValue());
            }
        }
        return null;
    }

    public static JsonObject to(ObjectNode json) {
        return StreamUtil.stream(json.fields()).map(e -> Pair.pair((String)e.getKey(), Jackson.to((JsonNode)e.getValue()))).filter(pair -> pair.second != null).reduce(JsonUtil.createObjectBuilder(), (builder, pair) -> builder.add((String)pair.first, (JsonValue)pair.second), (b1, b2) -> b1).build();
    }

    public static JsonArray to(ArrayNode json) {
        return StreamUtil.stream(json.elements()).map(Jackson::to).filter(Objects::nonNull).reduce(JsonUtil.createArrayBuilder(), JsonArrayBuilder::add, (b1, b2) -> b1).build();
    }

    private static JsonValue toNumber(JsonNode json) {
        return json.isIntegralNumber() ? JsonUtil.createValue(json.longValue()) : JsonUtil.createValue(json.decimalValue());
    }
}

