/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.Parser;
import com.schibsted.spt.data.jslt.ResourceResolver;
import com.schibsted.spt.data.jslt.impl.ClasspathResourceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import javax.json.JsonValue;
import net.pincette.json.Jackson;
import net.pincette.json.JsltCustom;
import net.pincette.json.JsonUtil;
import net.pincette.util.Pair;
import net.pincette.util.Util;

public class Jslt {
    private static final String RESOURCE = "resource:";
    private static final Set<JsltCustom.CustomFunction> customFunctions = new HashSet<JsltCustom.CustomFunction>();

    private Jslt() {
    }

    private static java.util.function.Function<JsonValue, JsonObject> asObject() {
        return json -> Optional.ofNullable(json).filter(JsonUtil::isObject).map(JsonValue::asJsonObject).orElse(null);
    }

    private static java.util.function.Function<JsonObject, JsonValue> asValue() {
        return json -> json;
    }

    public static Reader reader(File file) {
        return Util.tryToGetRethrow(() -> Jslt.reader(new FileInputStream(file))).orElse(null);
    }

    public static Reader reader(InputStream in) {
        return new InputStreamReader(in, StandardCharsets.UTF_8);
    }

    public static Reader readerResource(String resource) {
        return Jslt.reader(Jslt.class.getResourceAsStream(resource));
    }

    private static Set<JsltCustom.CustomFunction> toCustom(Collection<Function> functions) {
        return functions.stream().map(JsltCustom.CustomFunction::new).collect(Collectors.toSet());
    }

    private static Collection<Function> toFunction(Set<JsltCustom.CustomFunction> functions) {
        return functions.stream().map(Function.class::cast).collect(Collectors.toList());
    }

    public static UnaryOperator<JsonObject> transformerObject(Context context) {
        java.util.function.Function<JsonObject, JsonObject> transformer = Jslt.asObject().compose(Jslt.transformerValue(context)).compose(Jslt.asValue());
        return transformer::apply;
    }

    public static UnaryOperator<JsonValue> transformerValue(Context context) {
        Parser parser = new Parser(context.reader);
        Expression jslt = parser.withFunctions(Jslt.toFunction(net.pincette.util.Collections.union(customFunctions, context.functions != null ? Jslt.toCustom(context.functions) : Collections.emptySet()))).withResourceResolver(context.resolver != null ? context.resolver : new ClasspathResourceResolver()).compile();
        Map<String, JsonNode> vars = Jslt.variables(context.variables);
        return json -> Optional.ofNullable(Jackson.to(jslt.apply(vars, Jackson.from(json)))).orElse(null);
    }

    public static Reader tryReader(String jslt) {
        Supplier<Reader> tryFile = () -> new File(jslt).exists() ? Jslt.reader(new File(jslt)) : new StringReader(jslt);
        return jslt.startsWith(RESOURCE) ? Jslt.readerResource(jslt.substring(RESOURCE.length())) : tryFile.get();
    }

    private static Map<String, JsonNode> variables(Map<String, JsonValue> variables) {
        return Optional.ofNullable(variables).map(v -> v.entrySet().stream().map(e -> Pair.pair((String)e.getKey(), Jackson.from((JsonValue)e.getValue()))).filter(pair -> pair.second != null).collect(Collectors.toMap(pair -> (String)pair.first, pair -> (JsonNode)pair.second))).orElseGet(Collections::emptyMap);
    }

    public static class Context {
        final Collection<Function> functions;
        final Reader reader;
        final ResourceResolver resolver;
        final Map<String, JsonValue> variables;

        public Context(Reader reader) {
            this(reader, null, null, null);
        }

        private Context(Reader reader, Collection<Function> functions, Map<String, JsonValue> variables, ResourceResolver resolver) {
            this.reader = reader;
            this.functions = functions;
            this.variables = variables != null ? variables : Collections.emptyMap();
            this.resolver = resolver;
        }

        public Context withFunctions(Collection<Function> functions) {
            return new Context(this.reader, functions, this.variables, this.resolver);
        }

        public Context withResolver(ResourceResolver resolver) {
            return new Context(this.reader, this.functions, this.variables, resolver);
        }

        public Context withVariables(Map<String, JsonValue> variables) {
            return new Context(this.reader, this.functions, variables, this.resolver);
        }
    }

    public static class MapResolver
    implements ResourceResolver {
        private final Map<String, String> map;

        public MapResolver(Map<String, String> map) {
            this.map = map;
        }

        @Override
        public Reader resolve(String jslt) {
            return Optional.ofNullable(this.map.get(jslt)).map(StringReader::new).orElse(null);
        }
    }
}

