/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.Function;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonString;
import javax.json.JsonValue;
import net.pincette.function.SideEffect;
import net.pincette.json.Jackson;
import net.pincette.json.JsonUtil;
import net.pincette.util.Collections;
import net.pincette.util.Pair;
import net.pincette.util.Triple;
import net.pincette.util.Util;

public class JsltCustom {
    private JsltCustom() {
    }

    public static Function base64Decode() {
        return JsltCustom.function("base64-decode", 1, 1, array -> JsonUtil.createValue(new String(Base64.getDecoder().decode(JsonUtil.asString((JsonValue)array.get(0)).getString().getBytes(StandardCharsets.US_ASCII)), StandardCharsets.UTF_8)));
    }

    public static Function base64Encode() {
        return JsltCustom.function("base64-encode", 1, 1, array -> JsonUtil.createValue(new String(Base64.getEncoder().encode(JsonUtil.asString((JsonValue)array.get(0)).getString().getBytes(StandardCharsets.UTF_8)), StandardCharsets.US_ASCII)));
    }

    public static Collection<Function> customFunctions() {
        return Collections.list(JsltCustom.base64Decode(), JsltCustom.base64Encode(), JsltCustom.getPointer(), JsltCustom.parseIsoInstant(), JsltCustom.pointer(), JsltCustom.setPointer(), JsltCustom.uriDecode(), JsltCustom.uriEncode(), JsltCustom.uuid());
    }

    public static Function function(String name, int minArguments, int maxArguments, java.util.function.Function<JsonArray, JsonValue> function) {
        return new CustomFunction(name, minArguments, maxArguments, (input, arguments) -> Jackson.from((JsonValue)function.apply(Arrays.stream(arguments).reduce(JsonUtil.createArrayBuilder(), (b, v) -> b.add(Jackson.to(v)), (b1, b2) -> b1).build())));
    }

    public static Function getPointer() {
        return JsltCustom.function("get-pointer", 2, 3, array -> Optional.of(array).map(a -> Pair.pair((JsonValue)a.get(0), (JsonValue)a.get(1))).filter(pair -> JsonUtil.isObject((JsonValue)pair.first) && JsonUtil.isString((JsonValue)pair.second)).flatMap(pair -> JsonUtil.getValue(((JsonValue)pair.first).asJsonObject(), JsonUtil.asString((JsonValue)pair.second).getString())).orElseGet(() -> array.size() == 3 ? (JsonValue)array.get(2) : JsonValue.NULL));
    }

    public static Function parseIsoInstant() {
        return JsltCustom.function("parse-iso-instant", 1, 1, array -> Optional.of((JsonValue)array.get(0)).filter(JsonUtil::isInstant).map(JsonUtil::asInstant).map(Instant::toEpochMilli).map(v -> Math.round((double)v.longValue() / 1000.0)).map(JsonUtil::createValue).orElse(JsonValue.NULL));
    }

    public static Function pointer() {
        return JsltCustom.function("pointer", 1, Integer.MAX_VALUE, array -> JsonUtil.createValue("/" + array.stream().filter(JsonUtil::isString).map(JsonUtil::asString).map(JsonString::getString).collect(Collectors.joining("/"))));
    }

    public static Function setPointer() {
        return JsltCustom.function("set-pointer", 3, 3, array -> Optional.of(array).map(a -> Triple.triple((JsonValue)a.get(0), (JsonValue)a.get(1), (JsonValue)a.get(2))).filter(triple -> JsonUtil.isObject((JsonValue)triple.first) && JsonUtil.isString((JsonValue)triple.second)).map(triple -> JsonUtil.add(((JsonValue)triple.first).asJsonObject(), JsonUtil.toDotSeparated(JsonUtil.asString((JsonValue)triple.second).getString()), (JsonValue)triple.third)).orElse(JsonValue.NULL));
    }

    public static Function trace(Logger logger) {
        return JsltCustom.function("trace", 1, 1, array -> SideEffect.run(() -> logger.info(JsonUtil.string((JsonValue)array.get(0)))).andThenGet(() -> (JsonValue)array.get(0)));
    }

    public static Function uriDecode() {
        return JsltCustom.function("uri-decode", 1, 1, array -> JsonUtil.createValue(Util.tryToGetRethrow(() -> URLDecoder.decode(JsonUtil.asString((JsonValue)array.get(0)).getString(), "UTF-8")).orElse(null)));
    }

    public static Function uriEncode() {
        return JsltCustom.function("uri-encode", 1, 1, array -> JsonUtil.createValue(Util.tryToGetRethrow(() -> URLEncoder.encode(JsonUtil.asString((JsonValue)array.get(0)).getString(), "UTF-8")).orElse(null)));
    }

    public static Function uuid() {
        return JsltCustom.function("uuid", 0, 0, array -> JsonUtil.createValue(UUID.randomUUID().toString()));
    }

    static class CustomFunction
    implements Function {
        private final BiFunction<JsonNode, JsonNode[], JsonNode> function;
        private final int minArguments;
        private final int maxArguments;
        private final String name;

        private CustomFunction(String name, int minArguments, int maxArguments, BiFunction<JsonNode, JsonNode[], JsonNode> function) {
            this.name = name;
            this.minArguments = minArguments;
            this.maxArguments = maxArguments;
            this.function = function;
        }

        CustomFunction(Function delegate) {
            this.name = delegate.getName();
            this.minArguments = delegate.getMinArguments();
            this.maxArguments = delegate.getMaxArguments();
            this.function = delegate::call;
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            return this.function.apply(input, arguments);
        }

        public boolean equals(Object other) {
            return other instanceof CustomFunction && ((CustomFunction)other).name.equals(this.name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getMinArguments() {
            return this.minArguments;
        }

        @Override
        public int getMaxArguments() {
            return this.maxArguments;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

