/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json;

import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Optional;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.stream.JsonParser;
import net.pincette.json.JsonUtil;
import net.pincette.json.filter.JacksonGenerator;
import net.pincette.json.filter.JacksonParser;
import net.pincette.json.filter.JsonParserWrapper;
import net.pincette.util.Util;

public class JsonOrYaml {
    private static final YAMLFactory factory = YAMLFactory.builder().build().enable(YAMLGenerator.Feature.LITERAL_BLOCK_STYLE);

    private JsonOrYaml() {
    }

    private static JsonStructure get(JsonParser parser) {
        return parser.next() == JsonParser.Event.START_OBJECT ? parser.getObject() : parser.getArray();
    }

    private static Optional<File> getFile(String filename) {
        return Optional.of(new File(filename)).filter(File::exists).map(Optional::of).orElseGet(() -> JsonOrYaml.getFile(filename, new String[]{"yml", "yaml", "json"}));
    }

    private static Optional<File> getFile(String filename, String[] extensions) {
        return Arrays.stream(extensions).map(extension -> new File(filename + "." + extension)).filter(File::exists).findFirst();
    }

    public static Optional<JsonStructure> read(String filename) {
        return JsonOrYaml.getFile(filename).flatMap(JsonOrYaml::read);
    }

    public static Optional<JsonStructure> read(File file) {
        return Util.tryToGetWithRethrow(() -> new FileReader(file), reader -> file.getName().endsWith(".yaml") || file.getName().endsWith(".yml") ? (JsonStructure)JsonOrYaml.readYaml(reader).orElse(null) : (JsonStructure)JsonOrYaml.readJson(reader).orElse(null));
    }

    public static Optional<JsonStructure> readJson(Reader reader) {
        return Util.tryToGetWithRethrow(() -> JsonUtil.createReader(reader), JsonReader::read);
    }

    public static Optional<JsonStructure> readYaml(Reader reader) {
        return Util.tryToGetWithRethrow(() -> new JsonParserWrapper(new JacksonParser(factory.createParser(reader))), JsonOrYaml::get);
    }

    public static void writeJson(JsonStructure json, Writer writer) {
        Util.tryToDoWithRethrow(() -> JsonUtil.createWriter(writer), w -> w.write(json));
    }

    public static void writeYaml(JsonStructure json, Writer writer) {
        Util.tryToDoWithRethrow(() -> new JacksonGenerator(factory.createGenerator(writer)), generator -> generator.write(json));
    }
}

