/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.json.JsonStructure;
import net.pincette.json.JsonUtil;
import net.pincette.util.Util;

public class JsonStructureIterator
implements Iterator<JsonStructure> {
    final Reader reader;
    JsonStructure next;

    public JsonStructureIterator(InputStream in) {
        this.reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    private static Optional<String> readStructure(Reader reader) {
        int c;
        StringBuilder builder = new StringBuilder(1024);
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        while ((c = Util.tryToGetRethrow(reader::read).orElse(-1).intValue()) != -1) {
            builder.append((char)c);
            if (c == 123 || c == 91) {
                stack.push(c);
                continue;
            }
            if (c != 125 && c != 93) continue;
            stack.pop();
            if (!stack.isEmpty()) continue;
            return Optional.of(builder.toString());
        }
        return Optional.empty();
    }

    @Override
    public boolean hasNext() {
        this.next = JsonStructureIterator.readStructure(this.reader).flatMap(JsonUtil::from).orElse(null);
        return this.next != null;
    }

    @Override
    public JsonStructure next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        return this.next;
    }
}

