/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonException;
import javax.json.JsonMergePatch;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonPointer;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import net.pincette.function.SideEffect;
import net.pincette.json.Transform;
import net.pincette.util.Pair;
import net.pincette.util.Util;
import net.pincette.xml.JsonEventReader;

public class JsonUtil {
    public static final Function<JsonObject, ?> EVALUATOR = value -> value.getValueType() == JsonValue.ValueType.NUMBER ? Long.valueOf(JsonUtil.asNumber(value).longValue()) : JsonUtil.toString(value);
    private static final JsonProvider provider = JsonProvider.provider();

    private JsonUtil() {
    }

    public static JsonObject add(JsonObject obj, String name, JsonArrayBuilder value) {
        return JsonUtil.add(obj, builder -> builder.add(name, value));
    }

    public static JsonObject add(JsonObject obj, String name, JsonObjectBuilder value) {
        return JsonUtil.add(obj, builder -> builder.add(name, value));
    }

    public static JsonObject add(JsonObject obj, String path, JsonValue value) {
        return JsonUtil.createPointer(JsonUtil.toJsonPointer(path)).add(obj, value).asJsonObject();
    }

    public static JsonObject add(JsonObject obj, String path, Object value) {
        return JsonUtil.add(obj, path, JsonUtil.createValue(value));
    }

    public static JsonObject add(JsonObject obj, UnaryOperator<JsonObjectBuilder> add) {
        return ((JsonObjectBuilder)add.apply(JsonUtil.copy(obj, JsonUtil.createObjectBuilder()))).build();
    }

    public static JsonObject add(JsonObject obj1, JsonObject obj2) {
        return JsonUtil.add(obj1, builder -> JsonUtil.copy(obj2, builder));
    }

    public static JsonObject add(JsonObject obj, Map<String, ?> fields) {
        return JsonUtil.add(obj, builder -> JsonUtil.add(builder, fields));
    }

    public static JsonObjectBuilder add(JsonObjectBuilder builder, Map<String, ?> fields) {
        return fields.entrySet().stream().reduce(builder, (b, e) -> JsonUtil.addJsonField(b, (String)e.getKey(), e.getValue()), (b1, b2) -> b1);
    }

    public static JsonObjectBuilder add(JsonObjectBuilder builder, JsonObject obj) {
        return JsonUtil.copy(obj, builder);
    }

    public static JsonArrayBuilder add(JsonArrayBuilder builder, JsonArray array) {
        return array.stream().reduce(builder, JsonArrayBuilder::add, (b1, b2) -> b1);
    }

    public static JsonObject add(JsonObject obj, Collection<Pair<String, Object>> values) {
        return values.stream().reduce(JsonUtil.copy(obj, JsonUtil.createObjectBuilder()), (b, p) -> JsonUtil.addJsonField(b, (String)p.first, p.second), (b1, b2) -> b1).build();
    }

    public static JsonArray add(JsonArray array, JsonValue value) {
        return JsonUtil.set(array, array.size(), value);
    }

    public static JsonArray add(JsonArray array, Object value) {
        return JsonUtil.set(array, array.size(), JsonUtil.createValue(value));
    }

    public static JsonObjectBuilder addIf(JsonObjectBuilder builder, BooleanSupplier test, UnaryOperator<JsonObjectBuilder> add) {
        return test.getAsBoolean() ? (JsonObjectBuilder)add.apply(builder) : builder;
    }

    public static JsonObjectBuilder addJsonField(JsonObjectBuilder builder, String name, Object value) {
        return builder.add(name, JsonUtil.createValue(value));
    }

    public static JsonArrayBuilder addJsonField(JsonArrayBuilder builder, Object value) {
        return builder.add(JsonUtil.createValue(value));
    }

    public static Optional<JsonArray> arrayValue(JsonValue value) {
        return Optional.of(value).filter(JsonUtil::isArray).map(JsonValue::asJsonArray);
    }

    public static JsonArray asArray(JsonValue value) {
        if (value.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new JsonException("Not an array");
        }
        return (JsonArray)value;
    }

    public static double asDouble(JsonValue value) {
        return JsonUtil.asNumber(value).doubleValue();
    }

    public static Instant asInstant(JsonValue value) {
        return Instant.parse(JsonUtil.asString(value).getString());
    }

    public static int asInt(JsonValue value) {
        return JsonUtil.asNumber(value).intValueExact();
    }

    public static long asLong(JsonValue value) {
        return JsonUtil.asNumber(value).longValueExact();
    }

    public static JsonNumber asNumber(JsonValue value) {
        if (value.getValueType() != JsonValue.ValueType.NUMBER) {
            throw new JsonException("Not a number");
        }
        return (JsonNumber)value;
    }

    public static JsonObject asObject(JsonValue value) {
        if (value.getValueType() != JsonValue.ValueType.OBJECT) {
            throw new JsonException("Not an object");
        }
        return (JsonObject)value;
    }

    public static JsonString asString(JsonValue value) {
        if (value.getValueType() != JsonValue.ValueType.STRING) {
            throw new JsonException("Not a string");
        }
        return (JsonString)value;
    }

    private static Object convertNumber(JsonNumber number) {
        return number.isIntegral() ? (double)number.longValue() : number.doubleValue();
    }

    public static JsonObjectBuilder copy(JsonObject obj, JsonObjectBuilder builder) {
        return JsonUtil.copy(obj, builder, (String key) -> true);
    }

    public static JsonObjectBuilder copy(JsonObject obj, JsonObjectBuilder builder, Predicate<String> retain) {
        return JsonUtil.copy(obj, builder, (String key, JsonObject o) -> retain.test((String)key));
    }

    public static JsonObjectBuilder copy(JsonObject obj, JsonObjectBuilder builder, BiPredicate<String, JsonObject> retain) {
        return obj.keySet().stream().filter(key -> retain.test((String)key, obj)).reduce(builder, (b, key) -> b.add((String)key, (JsonValue)obj.get(key)), (b1, b2) -> b1);
    }

    public static JsonArrayBuilder copy(JsonArray array, JsonArrayBuilder builder, Predicate<JsonValue> retain) {
        return array.stream().filter(retain).reduce(builder, JsonArrayBuilder::add, (b1, b2) -> b1);
    }

    public static JsonArrayBuilder createArrayBuilder() {
        return provider.createArrayBuilder();
    }

    public static JsonArrayBuilder createArrayBuilder(Collection<?> collection) {
        return provider.createArrayBuilder(collection);
    }

    public static JsonArrayBuilder createArrayBuilder(JsonArray array) {
        return provider.createArrayBuilder(array);
    }

    public static JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        return provider.createBuilderFactory(config);
    }

    public static JsonPatch createDiff(JsonStructure source, JsonStructure target) {
        return provider.createDiff(source, target);
    }

    public static JsonGenerator createGenerator(OutputStream out) {
        return provider.createGenerator(out);
    }

    public static JsonGenerator createGenerator(Writer writer) {
        return provider.createGenerator(writer);
    }

    public static JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        return provider.createGeneratorFactory(config);
    }

    public static JsonMergePatch createMergeDiff(JsonValue source, JsonValue target) {
        return provider.createMergeDiff(source, target);
    }

    public static JsonObjectBuilder createObjectBuilder() {
        return provider.createObjectBuilder();
    }

    public static JsonObjectBuilder createObjectBuilder(Map<String, Object> map) {
        return provider.createObjectBuilder(map);
    }

    public static JsonObjectBuilder createObjectBuilder(JsonObject object) {
        return provider.createObjectBuilder(object);
    }

    public static JsonParser createParser(InputStream in) {
        return provider.createParser(in);
    }

    public static JsonParser createParser(Reader reader) {
        return provider.createParser(reader);
    }

    public static JsonParserFactory createParserFactory(Map<String, ?> config) {
        return provider.createParserFactory(config);
    }

    public static JsonPatch createPatch(JsonArray array) {
        return provider.createPatch(array);
    }

    public static JsonPatchBuilder createPatchBuilder() {
        return provider.createPatchBuilder();
    }

    public static JsonPatchBuilder createPatchBuilder(JsonArray array) {
        return provider.createPatchBuilder(array);
    }

    public static JsonPointer createPointer(String jsonPointer) {
        return provider.createPointer(jsonPointer);
    }

    public static JsonReader createReader(InputStream in) {
        return provider.createReader(in);
    }

    public static JsonReader createReader(Reader reader) {
        return provider.createReader(reader);
    }

    public static JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        return provider.createReaderFactory(config);
    }

    public static JsonValue createValue(Object value) {
        if (value == null) {
            return JsonValue.NULL;
        }
        if (value instanceof JsonValue) {
            return (JsonValue)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (value instanceof Integer) {
            return provider.createValue((Integer)value);
        }
        if (value instanceof Long) {
            return provider.createValue((Long)value);
        }
        if (value instanceof BigInteger) {
            return provider.createValue((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return provider.createValue((BigDecimal)value);
        }
        if (JsonUtil.isValidDouble(value) || JsonUtil.isValidFloat(value)) {
            return provider.createValue(((Number)value).doubleValue());
        }
        if (value instanceof Date) {
            return provider.createValue(Instant.ofEpochMilli(((Date)value).getTime()).toString());
        }
        if (value instanceof Map) {
            return JsonUtil.from((Map)value);
        }
        if (value instanceof Stream) {
            return JsonUtil.from((Stream)value);
        }
        if (value instanceof List) {
            return JsonUtil.from((List)value);
        }
        return provider.createValue(value.toString());
    }

    public static JsonWriter createWriter(OutputStream out) {
        return provider.createWriter(out);
    }

    public static JsonWriter createWriter(Writer writer) {
        return provider.createWriter(writer);
    }

    public static JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        return provider.createWriterFactory(config);
    }

    public static Optional<Double> doubleValue(JsonValue value) {
        return Optional.of(value).filter(JsonUtil::isDouble).map(JsonUtil::asDouble);
    }

    public static JsonArray emptyArray() {
        return JsonUtil.createArrayBuilder().build();
    }

    public static JsonObject emptyObject() {
        return JsonUtil.createObjectBuilder().build();
    }

    public static Object evaluate(JsonValue value) {
        return value.getValueType() == JsonValue.ValueType.NUMBER ? Long.valueOf(JsonUtil.asNumber(value).longValue()) : JsonUtil.toString(value);
    }

    public static JsonObject from(Map<String, ?> fields) {
        return JsonUtil.add(JsonUtil.createObjectBuilder(), fields).build();
    }

    public static JsonArray from(List<?> values) {
        return JsonUtil.from(values.stream());
    }

    public static JsonArray from(Stream<?> values) {
        return values.reduce(JsonUtil.createArrayBuilder(), JsonUtil::addJsonField, (b1, b2) -> b1).build();
    }

    public static Optional<JsonStructure> from(String json) {
        return Util.tryToGetSilent(() -> JsonUtil.createReader(new StringReader(json)).read());
    }

    public static Optional<JsonArray> getArray(JsonStructure json, String jsonPointer) {
        return JsonUtil.getValue(json, jsonPointer).filter(JsonUtil::isArray).map(JsonValue::asJsonArray);
    }

    public static Optional<JsonValue> get(JsonObject obj, String field) {
        return Util.pathSearch(obj, field.split("\\."));
    }

    public static Optional<Boolean> getBoolean(JsonStructure json, String jsonPointer) {
        return JsonUtil.getValue(json, jsonPointer).filter(v -> v.getValueType() == JsonValue.ValueType.TRUE || v.getValueType() == JsonValue.ValueType.FALSE).map(v -> v.getValueType() == JsonValue.ValueType.TRUE);
    }

    public static Optional<Instant> getInstant(JsonStructure json, String jsonPointer) {
        return JsonUtil.getValue(json, jsonPointer).filter(JsonUtil::isInstant).map(JsonUtil::asInstant);
    }

    public static String getKey(String path) {
        return JsonUtil.getKey(path, ".");
    }

    public static String getKey(String path, String pathDelimiter) {
        return Util.getLastSegment(path, Pattern.quote(pathDelimiter)).orElse(path);
    }

    public static Optional<Double> getNumber(JsonStructure json, String jsonPointer) {
        return JsonUtil.getValue(json, jsonPointer).flatMap(JsonUtil::doubleValue);
    }

    public static Stream<Double> getNumbers(JsonObject json, String array) {
        return JsonUtil.getValues(json, array, JsonUtil::numbers);
    }

    public static Optional<JsonObject> getObject(JsonStructure json, String jsonPointer) {
        return JsonUtil.getValue(json, jsonPointer).filter(JsonUtil::isObject).map(JsonValue::asJsonObject);
    }

    public static Stream<JsonObject> getObjects(JsonObject json, String array) {
        return JsonUtil.getValues(json, array, JsonUtil::objects);
    }

    public static String getParentPath(String path) {
        return Optional.of(path.lastIndexOf(46)).filter(i -> i != -1).map(i -> path.substring(0, (int)i)).orElse("");
    }

    public static Optional<String> getString(JsonStructure json, String jsonPointer) {
        return JsonUtil.getValue(json, jsonPointer).flatMap(JsonUtil::stringValue);
    }

    public static Stream<String> getStrings(JsonObject json, String array) {
        return JsonUtil.getValues(json, array, JsonUtil::strings);
    }

    public static Optional<JsonValue> getValue(JsonStructure json, String jsonPointer) {
        return Util.tryToGetSilent(() -> json.getValue(jsonPointer));
    }

    public static Stream<JsonValue> getValues(JsonObject json, String array) {
        return JsonUtil.getValues(json, array, Collection::stream);
    }

    public static <T> Stream<T> getValues(JsonObject json, String array, Function<JsonArray, Stream<T>> values) {
        return Optional.ofNullable(json.getJsonArray(array)).map(values).orElseGet(Stream::empty);
    }

    public static Optional<Integer> intValue(JsonValue value) {
        return Optional.of(value).filter(JsonUtil::isInt).map(JsonUtil::asInt);
    }

    public static boolean isArray(JsonValue value) {
        return value.getValueType() == JsonValue.ValueType.ARRAY;
    }

    public static boolean isBoolean(JsonValue value) {
        return value.getValueType() == JsonValue.ValueType.TRUE || value.getValueType() == JsonValue.ValueType.FALSE;
    }

    public static boolean isDate(JsonValue value) {
        return value.getValueType() == JsonValue.ValueType.STRING && Util.isDate(JsonUtil.asString(value).getString());
    }

    public static boolean isDouble(JsonValue value) {
        return JsonUtil.isNumber(value) && Optional.of(JsonUtil.asNumber(value).doubleValue()).filter(v -> v != Double.NEGATIVE_INFINITY && v != Double.POSITIVE_INFINITY).isPresent();
    }

    public static boolean isEmail(JsonValue value) {
        return value.getValueType() == JsonValue.ValueType.STRING && Util.isEmail(JsonUtil.asString(value).getString());
    }

    public static boolean isInstant(JsonValue value) {
        return value.getValueType() == JsonValue.ValueType.STRING && Util.isInstant(JsonUtil.asString(value).getString());
    }

    public static boolean isInt(JsonValue value) {
        return Util.tryToGetSilent(() -> JsonUtil.asNumber(value).intValueExact()).isPresent();
    }

    public static boolean isLong(JsonValue value) {
        return Util.tryToGetSilent(() -> JsonUtil.asNumber(value).longValueExact()).isPresent();
    }

    public static boolean isNull(JsonValue value) {
        return value.getValueType() == JsonValue.ValueType.NULL;
    }

    public static boolean isNumber(JsonValue value) {
        return value.getValueType() == JsonValue.ValueType.NUMBER;
    }

    public static boolean isObject(JsonValue value) {
        return value.getValueType() == JsonValue.ValueType.OBJECT;
    }

    public static boolean isString(JsonValue value) {
        return value.getValueType() == JsonValue.ValueType.STRING;
    }

    public static boolean isStructure(JsonValue value) {
        return JsonUtil.isObject(value) || JsonUtil.isArray(value);
    }

    public static boolean isUri(JsonValue value) {
        return JsonUtil.isUri(JsonUtil.asString(value).getString());
    }

    public static boolean isUri(String s) {
        return s.startsWith("/") || Util.isUri(s);
    }

    private static boolean isValidDouble(Object value) {
        return value instanceof Double && !value.equals(Double.NaN);
    }

    private static boolean isValidFloat(Object value) {
        return value instanceof Float && !value.equals(Float.valueOf(Float.NaN));
    }

    public static Optional<Long> longValue(JsonValue value) {
        return Optional.of(value).filter(JsonUtil::isLong).map(JsonUtil::asLong);
    }

    public static Stream<JsonObject> nestedObjects(JsonStructure json) {
        return JsonUtil.isArray(json) ? JsonUtil.nestedObjects(json.asJsonArray()) : JsonUtil.nestedObjects(json.asJsonObject());
    }

    public static Stream<JsonObject> nestedObjects(JsonObject json) {
        return JsonUtil.nestedObjectsAndSelf(json.values().stream());
    }

    public static Stream<JsonObject> nestedObjects(JsonArray json) {
        return JsonUtil.nestedObjectsAndSelf(json.stream());
    }

    private static Stream<JsonObject> nestedObjectsAndSelf(Stream<JsonValue> stream) {
        return stream.filter(j -> JsonUtil.isObject(j) || JsonUtil.isArray(j)).flatMap(j -> JsonUtil.isObject(j) ? Stream.concat(Stream.of(j.asJsonObject()), JsonUtil.nestedObjects(j.asJsonObject())) : JsonUtil.nestedObjects(j.asJsonArray()));
    }

    public static Stream<Double> numbers(JsonArray array) {
        return array.stream().map(v -> JsonUtil.doubleValue(v).orElse(null)).filter(Objects::nonNull);
    }

    public static Optional<JsonObject> objectValue(JsonValue value) {
        return Optional.of(value).filter(JsonUtil::isObject).map(JsonValue::asJsonObject);
    }

    public static Stream<JsonObject> objects(JsonArray array) {
        return array.stream().filter(JsonUtil::isObject).map(JsonValue::asJsonObject);
    }

    public static JsonObject remove(JsonObject obj, Set<String> fields) {
        return JsonUtil.remove(obj, fields::contains);
    }

    public static JsonObject remove(JsonObject obj, Predicate<String> pred) {
        return JsonUtil.copy(obj, JsonUtil.createObjectBuilder(), (String key) -> !pred.test((String)key)).build();
    }

    public static JsonArray remove(JsonArray array, Predicate<JsonValue> pred) {
        return JsonUtil.copy(array, JsonUtil.createArrayBuilder(), (JsonValue value) -> !pred.test((JsonValue)value)).build();
    }

    public static JsonArray remove(JsonArray array, int position) {
        return position < 0 || position >= array.size() ? array : JsonUtil.from(Stream.concat(array.subList(0, position).stream(), array.subList(position + 1, array.size()).stream()));
    }

    public static JsonObject removeTechnical(JsonObject obj) {
        return JsonUtil.copy(obj, JsonUtil.createObjectBuilder(), (String key) -> !key.startsWith("_")).build();
    }

    public static JsonObject set(JsonObject obj, String path, JsonValue value) {
        return Transform.transform(obj, Transform.setTransformer(path, value));
    }

    public static JsonObject set(JsonObject obj, String path, Object value) {
        return JsonUtil.set(obj, path, JsonUtil.createValue(value));
    }

    public static JsonArray set(JsonArray array, int position, JsonValue value) {
        Supplier<Stream> secondPart = () -> position < array.size() ? array.subList(position + 1, array.size()).stream() : Stream.empty();
        return position < 0 || position > array.size() ? array : JsonUtil.from(Stream.concat(Stream.concat(array.subList(0, position).stream(), Stream.of(value)), secondPart.get()));
    }

    public static JsonArray set(JsonArray array, int position, Object value) {
        return JsonUtil.set(array, position, JsonUtil.createValue(value));
    }

    public static String string(JsonValue json) {
        return JsonUtil.string(json, false);
    }

    public static String string(JsonValue json, boolean pretty) {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        StringWriter writer = new StringWriter();
        if (pretty) {
            config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        }
        Util.tryToDoWith(() -> JsonUtil.createWriterFactory(config).createWriter(writer), w -> w.write(json));
        return writer.toString();
    }

    public static Optional<String> stringValue(JsonValue value) {
        return Optional.of(value).filter(JsonUtil::isString).map(JsonUtil::asString).map(JsonString::getString);
    }

    public static Stream<String> strings(JsonArray array) {
        return array.stream().map(v -> JsonUtil.stringValue(v).orElse(null)).filter(Objects::nonNull);
    }

    public static String toDotSeparated(String jsonPointer) {
        return Util.getSegments(jsonPointer, "/").collect(Collectors.joining("."));
    }

    public static String toJsonPointer(String dotSeparatedField) {
        return "/" + String.join((CharSequence)"/", dotSeparatedField.split("\\."));
    }

    public static Object toNative(JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                return JsonUtil.toNative(JsonUtil.asArray(value));
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case NUMBER: {
                return JsonUtil.convertNumber(JsonUtil.asNumber(value));
            }
            case OBJECT: {
                return JsonUtil.toNative(JsonUtil.asObject(value));
            }
            case STRING: {
                return JsonUtil.asString(value).getString();
            }
            case NULL: {
                return null;
            }
        }
        return value;
    }

    public static List<Object> toNative(JsonArray array) {
        return array.stream().map(JsonUtil::toNative).collect(Collectors.toList());
    }

    public static Map<String, Object> toNative(JsonObject object) {
        return object.entrySet().stream().map(e -> Pair.pair((String)e.getKey(), JsonUtil.toNative((JsonValue)e.getValue()))).filter(pair -> pair.second != null).collect(Collectors.toMap(pair -> (String)pair.first, pair -> pair.second));
    }

    private static String toString(JsonValue value) {
        return value.getValueType() == JsonValue.ValueType.STRING ? JsonUtil.asString(value).getString() : value.toString();
    }

    public static InputStream transformToXML(JsonStructure json) {
        return Optional.of(new ByteArrayOutputStream()).map(out -> SideEffect.run(() -> Util.tryToDoWithRethrow(Util.autoClose(() -> XMLOutputFactory.newInstance().createXMLEventWriter((OutputStream)out), XMLEventWriter::close), writer -> writer.add(new JsonEventReader(json instanceof JsonObject ? JsonUtil.createParserFactory(null).createParser((JsonObject)json) : JsonUtil.createParserFactory(null).createParser((JsonArray)json))))).andThenGet(() -> out)).map(ByteArrayOutputStream::toByteArray).map(ByteArrayInputStream::new).orElse(null);
    }
}

