/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.util.Collections;
import net.pincette.util.StreamUtil;

public class Patch {
    private static final String ADD = "add";
    private static final String COPY = "copy";
    private static final String FROM = "from";
    private static final String MOVE = "move";
    private static final String OP = "op";
    private static final String PATH = "path";
    private static final String REMOVE = "remove";
    private static final String REPLACE = "replace";
    private static final Set<String> OPS = Collections.set("add", "copy", "move", "remove", "replace");
    private static final Set<String> SET_OPS = Collections.set("add", "copy", "move", "replace");
    private static final String VALUE = "/value";

    private Patch() {
    }

    public static boolean added(JsonArray patch, JsonObject original, String jsonPointer) {
        return !JsonUtil.getValue(original, jsonPointer).isPresent() && Patch.isSet(patch, jsonPointer);
    }

    public static boolean changed(JsonArray patch, String jsonPointer) {
        return Patch.changes(patch, jsonPointer, false).findFirst().isPresent();
    }

    public static boolean changed(JsonArray patch, JsonObject original, String jsonPointer, JsonValue from, JsonValue to) {
        JsonObject[] changes = (JsonObject[])Patch.changes(patch, jsonPointer, true).toArray(JsonObject[]::new);
        return Patch.isRemoveThenAdd(changes, original, from, to) || Patch.isReplace(changes, original, from, to) || Patch.isMove(changes, original, from, to);
    }

    public static boolean changed(JsonArray patch, JsonObject original, String jsonPointer, JsonValue to) {
        JsonObject[] changes = (JsonObject[])Patch.changes(patch, jsonPointer, true).toArray(JsonObject[]::new);
        return Patch.isRemoveThenAdd(changes, to) || Patch.isReplace(changes, to) || Patch.isMove(changes, original, to);
    }

    private static Stream<JsonObject> changes(JsonArray patch) {
        return patch.stream().filter(JsonUtil::isObject).map(JsonValue::asJsonObject).filter(json -> json.containsKey(OP));
    }

    private static Stream<JsonObject> changes(JsonArray patch, String jsonPointer, boolean exact) {
        return Patch.changes(patch, jsonPointer, exact, OPS);
    }

    private static Stream<JsonObject> changes(JsonArray patch, String jsonPointer, boolean exact, Set<String> ops) {
        return Patch.changes(patch).filter(json -> ops.contains(json.getString(OP))).filter(json -> Patch.comparePaths(json.getString(PATH, ""), jsonPointer, exact));
    }

    private static boolean comparePaths(String found, String given, boolean exact) {
        return exact ? found.equals(given) : found.startsWith(given);
    }

    private static boolean isMove(JsonObject[] changes, JsonObject original, JsonValue from, JsonValue to) {
        return changes.length == 1 && changes[0].getString(OP).equals(MOVE) && Patch.isValue(changes[0], PATH, original, from) && Patch.isValue(changes[0], FROM, original, to);
    }

    private static boolean isMove(JsonObject[] changes, JsonObject original, JsonValue to) {
        return changes.length == 1 && changes[0].getString(OP).equals(MOVE) && Patch.isValue(changes[0], FROM, original, to);
    }

    private static boolean isRemove(JsonObject change, String jsonPointer) {
        return Optional.of(change.getString(OP)).map(op -> op.equals(REMOVE) && Patch.isSubject(change, PATH, jsonPointer) || op.equals(MOVE) && Patch.isSubject(change, FROM, jsonPointer)).orElse(false);
    }

    private static boolean isRemoveThenAdd(JsonObject[] changes, JsonObject original, JsonValue from, JsonValue to) {
        return changes.length == 2 && changes[0].getString(OP).equals(REMOVE) && changes[1].getString(OP).equals(ADD) && changes[1].getValue(VALUE).equals(to) && Patch.isValue(changes[0], PATH, original, from);
    }

    private static boolean isRemoveThenAdd(JsonObject[] changes, JsonValue to) {
        return changes.length == 2 && changes[0].getString(OP).equals(REMOVE) && changes[1].getString(OP).equals(ADD) && changes[1].getValue(VALUE).equals(to);
    }

    private static boolean isReplace(JsonObject[] changes, JsonObject original, JsonValue from, JsonValue to) {
        return changes.length == 1 && changes[0].getString(OP).equals(REPLACE) && changes[0].getValue(VALUE).equals(to) && Patch.isValue(changes[0], PATH, original, from);
    }

    private static boolean isReplace(JsonObject[] changes, JsonValue to) {
        return changes.length == 1 && changes[0].getString(OP).equals(REPLACE) && changes[0].getValue(VALUE).equals(to);
    }

    public static boolean isSet(JsonArray patch, String jsonPointer) {
        return Patch.changes(patch, jsonPointer, true, SET_OPS).findFirst().isPresent();
    }

    private static boolean isSet(JsonObject change, String jsonPointer) {
        return Optional.of(change.getString(OP)).map(op -> SET_OPS.contains(op) && Patch.isSubject(change, PATH, jsonPointer)).orElse(false);
    }

    private static boolean isSubject(JsonObject change, String attribute, String jsonPointer) {
        return Optional.ofNullable(change.getString(attribute, "")).map(value -> value.equals(jsonPointer)).orElse(false);
    }

    private static boolean isValue(JsonObject change, String attribute, JsonObject original, JsonValue value) {
        return JsonUtil.getValue(original, change.getString(attribute)).filter(v -> v.equals(value)).isPresent();
    }

    public static boolean removed(JsonArray patch, String jsonPointer) {
        return StreamUtil.last(Patch.removedOrSet(patch, jsonPointer)).map(change -> Patch.isRemove(change, jsonPointer)).orElse(false);
    }

    private static Stream<JsonObject> removedOrSet(JsonArray patch, String jsonPointer) {
        return Patch.changes(patch).filter(change -> Patch.isRemove(change, jsonPointer) || Patch.isSet(change, jsonPointer));
    }
}

