/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.util.Pair;

public class Transform {
    private Transform() {
    }

    private static String getKey(String path, String originalKey, String pathDelimter) {
        return Optional.ofNullable(originalKey).map(path::lastIndexOf).filter(index -> index != -1).map(index -> originalKey).orElseGet(() -> JsonUtil.getKey(path, pathDelimter));
    }

    private static String getPath(String parent, String key, String pathDelimiter) {
        return (String)(parent != null && !"".equals(parent) ? parent + pathDelimiter : "") + key;
    }

    public static Transformer nopTransformer() {
        return new Transformer(e -> false, Optional::of);
    }

    public static Transformer removeTransformer(String path) {
        return new Transformer(e -> e.path.equals(path), e -> Optional.empty());
    }

    public static Transformer setTransformer(String path, JsonValue value) {
        return new Transformer(e -> e.path.equals(path), e -> Optional.of(new JsonEntry(e.path, value)));
    }

    public static Transformer setTransformer(String path, Object value) {
        return Transform.setTransformer(path, JsonUtil.createValue(value));
    }

    public static JsonValue transform(JsonValue json, Transformer transformer) {
        return Transform.transform(json, null, transformer, ".");
    }

    public static JsonValue transform(JsonValue json, Transformer transformer, String pathDelimiter) {
        return Transform.transform(json, null, transformer, pathDelimiter);
    }

    private static JsonValue transform(JsonValue json, String parent, Transformer transformer, String pathDelimiter) {
        return json instanceof JsonStructure ? Transform.transform((JsonStructure)json, parent, transformer, pathDelimiter) : json;
    }

    public static JsonStructure transform(JsonStructure json, Transformer transformer) {
        return Transform.transform(json, null, transformer, ".");
    }

    public static JsonStructure transform(JsonStructure json, Transformer transformer, String pathDelimiter) {
        return Transform.transform(json, null, transformer, pathDelimiter);
    }

    private static JsonStructure transform(JsonStructure json, String parent, Transformer transformer, String pathDelimiter) {
        return json instanceof JsonArray ? Transform.transform((JsonArray)json, parent, transformer, pathDelimiter) : Transform.transform((JsonObject)json, parent, transformer, pathDelimiter);
    }

    public static JsonArray transform(JsonArray array, Transformer transformer) {
        return Transform.transformBuilder(array, null, transformer, ".").build();
    }

    public static JsonArray transform(JsonArray array, Transformer transformer, String pathDelimiter) {
        return Transform.transformBuilder(array, null, transformer, pathDelimiter).build();
    }

    private static JsonArray transform(JsonArray array, String parent, Transformer transformer, String pathDelimiter) {
        return Transform.transformBuilder(array, parent, transformer, pathDelimiter).build();
    }

    public static JsonObject transform(JsonObject obj, Transformer transformer) {
        return Transform.transform(obj, null, transformer, ".");
    }

    public static JsonObject transform(JsonObject obj, Transformer transformer, String pathDelimiter) {
        return Transform.transform(obj, null, transformer, pathDelimiter);
    }

    private static JsonObject transform(JsonObject obj, String parent, Transformer transformer, String pathDelimiter) {
        return Transform.transformBuilder(obj, parent, transformer, pathDelimiter).build();
    }

    public static JsonArrayBuilder transformBuilder(JsonArray array, Transformer transformer) {
        return Transform.transformBuilder(array, null, transformer, ".");
    }

    public static JsonArrayBuilder transformBuilder(JsonArray array, Transformer transformer, String pathDelimiter) {
        return Transform.transformBuilder(array, null, transformer, pathDelimiter);
    }

    private static JsonArrayBuilder transformBuilder(JsonArray array, String parent, Transformer transformer, String pathDelimiter) {
        return array.stream().filter(Objects::nonNull).reduce(JsonUtil.createArrayBuilder(), (b, v) -> b.add(Transform.transform(v, parent, transformer, pathDelimiter)), (b1, b2) -> b1);
    }

    public static JsonObjectBuilder transformBuilder(JsonObject obj, Transformer transformer) {
        return Transform.transformBuilder(obj, null, transformer, ".");
    }

    public static JsonObjectBuilder transformBuilder(JsonObject obj, Transformer transformer, String pathDelimiter) {
        return Transform.transformBuilder(obj, null, transformer, pathDelimiter);
    }

    private static JsonObjectBuilder transformBuilder(JsonObject obj, String parent, Transformer transformer, String pathDelimiter) {
        return (parent == null ? Stream.of("") : obj.keySet().stream()).reduce(JsonUtil.createObjectBuilder(), (b, k) -> ("".equals(k) ? Optional.of(new JsonEntry("", obj)) : transformer.run(new JsonEntry(Transform.getPath(parent, k, pathDelimiter), (JsonValue)obj.get(k)))).map(entry -> Transform.transformIfStructure(entry, k, parent, transformer, pathDelimiter)).map(entry -> "".equals(k) ? JsonUtil.copy(entry.value.asJsonObject(), b) : b.add(Transform.getKey(entry.path, k, pathDelimiter), entry.value)).orElse((JsonObjectBuilder)b), (b1, b2) -> b1);
    }

    private static JsonEntry transformIfStructure(JsonEntry entry, String key, String parentPath, Transformer transformer, String pathDelimiter) {
        return Optional.of(entry).filter(e -> JsonUtil.isStructure(e.value)).map(e -> Pair.pair(e, Transform.getPath(parentPath, Transform.getKey(e.path, key, pathDelimiter), pathDelimiter))).map(pair -> new JsonEntry((String)pair.second, Transform.transform(((JsonEntry)pair.first).value, (String)pair.second, transformer, pathDelimiter))).orElse(entry);
    }

    public static class Transformer {
        public final Predicate<JsonEntry> match;
        public final Transformer next;
        public final Function<JsonEntry, Optional<JsonEntry>> transform;

        public Transformer(Predicate<JsonEntry> match, Function<JsonEntry, Optional<JsonEntry>> transform) {
            this.match = match;
            this.next = null;
            this.transform = transform;
        }

        private Transformer(Transformer me, Transformer next) {
            this.match = me.match;
            this.transform = me.transform;
            this.next = me.next != null ? new Transformer(me.next, next) : next;
        }

        public Optional<JsonEntry> run(JsonEntry entry) {
            return this.runNext(!this.match.test(entry) ? Optional.of(entry) : this.transform.apply(entry));
        }

        private Optional<JsonEntry> runNext(Optional<JsonEntry> entry) {
            return this.next != null ? entry.flatMap(this.next::run) : entry;
        }

        public Transformer thenApply(Transformer transformer) {
            return new Transformer(this, transformer);
        }
    }

    public static class JsonEntry {
        public final String path;
        public final JsonValue value;

        public JsonEntry(String path, JsonValue value) {
            this.path = path;
            this.value = value;
        }
    }
}

