/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.util.Collections;
import net.pincette.util.Pair;
import net.pincette.util.Util;

public class Validate {
    public static final String ERROR = "_error";
    public static final String MESSAGE = "message";
    public static final String VALUE = "value";

    private Validate() {
    }

    public static JsonObject createErrorObject(JsonValue value, String message) {
        return Optional.of(JsonUtil.createObjectBuilder()).map(builder -> builder.add(ERROR, true)).map(builder -> builder.add(MESSAGE, message)).map(builder -> value != null ? builder.add(VALUE, value) : builder).map(JsonObjectBuilder::build).orElse(JsonUtil.emptyObject());
    }

    private static Stream<String> getFieldVariants(String field) {
        return Util.allPaths(field, ".");
    }

    private static Set<String> getMandatoryKeys(Set<String> all, String parent) {
        return parent == null ? all.stream().filter(key -> key.indexOf(46) == -1).collect(Collectors.toSet()) : all.stream().filter(key -> key.startsWith(parent + ".")).map(key -> key.substring(parent.length() + 1)).filter(key -> key.indexOf(46) == -1).collect(Collectors.toSet());
    }

    private static String getMessage(Map<String, String> messages, String field) {
        return Validate.getFieldVariants(field).filter(messages::containsKey).map(messages::get).findFirst().orElse("Error");
    }

    private static Validator getValidator(Map<String, Validator> validators, String field) {
        return Validate.getFieldVariants(field).filter(validators::containsKey).map(validators::get).findFirst().orElse(null);
    }

    public static boolean hasErrors(JsonObject obj) {
        return obj.get(ERROR) != null && obj.getBoolean(ERROR, false);
    }

    public static boolean hasErrors(JsonArray array) {
        return array.stream().anyMatch(value -> value instanceof JsonObject && Validate.hasErrors((JsonObject)value));
    }

    public static boolean hasErrors(JsonStructure json) {
        return json instanceof JsonObject && Validate.hasErrors((JsonObject)json) || json instanceof JsonArray && Validate.hasErrors((JsonArray)json);
    }

    public static ValidationResult isArray(ValidationContext context) {
        return new ValidationResult(JsonUtil.isArray(context.value), null);
    }

    public static ValidationResult isBoolean(ValidationContext context) {
        return new ValidationResult(JsonUtil.isBoolean(context.value), null);
    }

    public static ValidationResult isDate(ValidationContext context) {
        return new ValidationResult(JsonUtil.isDate(context.value), null);
    }

    public static ValidationResult isEmail(ValidationContext context) {
        return new ValidationResult(JsonUtil.isEmail(context.value), null);
    }

    public static ValidationResult isInstant(ValidationContext context) {
        return new ValidationResult(JsonUtil.isInstant(context.value), null);
    }

    public static ValidationResult isNumber(ValidationContext context) {
        return new ValidationResult(JsonUtil.isNumber(context.value), null);
    }

    public static ValidationResult isObject(ValidationContext context) {
        return new ValidationResult(JsonUtil.isObject(context.value), null);
    }

    public static ValidationResult isString(ValidationContext context) {
        return new ValidationResult(JsonUtil.isString(context.value), null);
    }

    public static ValidationResult isUri(ValidationContext context) {
        return new ValidationResult(JsonUtil.isUri(context.value), null);
    }

    public static JsonStructure validate(JsonStructure value, ValidationContext context, Map<String, Validator> validators, Map<String, String> messages, Set<String> mandatory, String missingMessage) {
        return (JsonStructure)Validate.validate(null, (JsonValue)value, (ValidationContext)context, validators, messages, mandatory, (String)missingMessage).first;
    }

    public static JsonObject validate(JsonObject obj, ValidationContext context, Map<String, Validator> validators, Map<String, String> messages, Set<String> mandatory, String missingMessage) {
        return (JsonObject)Validate.validate(null, (JsonObject)obj, (ValidationContext)context, validators, messages, mandatory, (String)missingMessage).first;
    }

    public static JsonArray validate(JsonArray array, ValidationContext context, Map<String, Validator> validators, Map<String, String> messages, Set<String> mandatory, String missingMessage) {
        return (JsonArray)Validate.validate(null, (JsonArray)array, (ValidationContext)context, validators, messages, mandatory, (String)missingMessage).first;
    }

    private static Pair<? extends JsonValue, Boolean> validate(String field, JsonValue value, ValidationContext context, Map<String, Validator> validators, Map<String, String> messages, Set<String> mandatory, String missingMessage) {
        Function<JsonValue, Pair> ifArrayOr = v -> v instanceof JsonArray ? Validate.validate(field, v.asJsonArray(), context, validators, messages, mandatory, missingMessage) : Pair.pair(v, false);
        return value instanceof JsonObject ? Validate.validate(field, value.asJsonObject(), context, validators, messages, mandatory, missingMessage) : ifArrayOr.apply(value);
    }

    private static Pair<JsonValue, Boolean> validate(String parent, JsonObject obj, ValidationContext context, Map<String, Validator> validators, Map<String, String> messages, Set<String> mandatory, String missingMessage) {
        JsonObjectBuilder builder = JsonUtil.createObjectBuilder();
        HashSet found = new HashSet();
        boolean errors = obj.keySet().stream().map(key -> {
            String field = parent != null ? parent + "." + key : key;
            JsonValue value = (JsonValue)obj.get(key);
            ValidationResult result = Optional.ofNullable(Validate.getValidator(validators, field)).map(validator -> (ValidationResult)validator.apply(context.with(field).with(value))).orElse(new ValidationResult(true, null));
            Supplier<String> message = () -> result.message != null ? result.message : Validate.getMessage(messages, field);
            Pair<? extends JsonValue, Boolean> entry = result.status ? Validate.validate(field, value, context, validators, messages, mandatory, missingMessage) : Pair.pair(Validate.createErrorObject(value, message.get()), true);
            found.add(key);
            builder.add((String)key, (JsonValue)entry.first);
            return (Boolean)entry.second;
        }).reduce(false, (e1, e2) -> e1 != false || e2 != false);
        if (errors |= Collections.difference(Validate.getMandatoryKeys(mandatory, parent), found).stream().map(key -> {
            builder.add((String)key, Validate.createErrorObject(null, missingMessage));
            return true;
        }).reduce(false, (e1, e2) -> e1 != false || e2 != false).booleanValue()) {
            builder.add(ERROR, true);
        }
        return Pair.pair(builder.build(), errors);
    }

    private static Pair<JsonArray, Boolean> validate(String parent, JsonArray array, ValidationContext context, Map<String, Validator> validators, Map<String, String> messages, Set<String> mandatory, String missingMessage) {
        JsonArrayBuilder builder = JsonUtil.createArrayBuilder();
        boolean errors = array.stream().map(value -> {
            Pair<? extends JsonValue, Boolean> entry = Validate.validate(parent, value, context, validators, messages, mandatory, missingMessage);
            builder.add((JsonValue)entry.first);
            return (Boolean)entry.second;
        }).reduce(false, (e1, e2) -> e1 != false || e2 != false);
        return Pair.pair(builder.build(), errors);
    }

    public static class ValidationResult {
        public final String message;
        public final boolean status;

        public ValidationResult(boolean status) {
            this(status, null);
        }

        public ValidationResult(boolean status, String message) {
            this.status = status;
            this.message = message;
        }
    }

    public static class ValidationContext {
        public final String field;
        public final JsonStructure newJson;
        public final JsonStructure oldJson;
        public final JsonValue value;

        public ValidationContext(JsonStructure oldJson, JsonStructure newJson) {
            this(oldJson, newJson, null, null);
        }

        private ValidationContext(JsonStructure oldJson, JsonStructure newJson, String field, JsonValue value) {
            this.oldJson = oldJson;
            this.newJson = newJson;
            this.field = field;
            this.value = value;
        }

        private ValidationContext with(String field) {
            return new ValidationContext(this.oldJson, this.newJson, field, this.value);
        }

        private ValidationContext with(JsonValue value) {
            return new ValidationContext(this.oldJson, this.newJson, this.field, value);
        }
    }

    public static interface Validator
    extends Function<ValidationContext, ValidationResult> {
    }
}

