/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json.filter;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import net.pincette.json.JsonUtil;
import net.pincette.json.filter.JsonBuilderGenerator;
import net.pincette.json.filter.JsonGeneratorFilter;

public class AccumulatingGeneratorFilter
extends JsonGeneratorFilter {
    private Object builder;
    private Deque<String> stack = new ArrayDeque<String>();

    private JsonValue build() {
        return this.builder instanceof JsonObjectBuilder ? ((JsonObjectBuilder)this.builder).build() : ((JsonArrayBuilder)this.builder).build();
    }

    @Override
    public JsonGenerator writeEnd() {
        String name = this.stack.pop();
        if (this.stack.isEmpty()) {
            this.removeAccumulator();
            if ("".equals(name)) {
                super.write(this.build());
            } else {
                super.write(name, this.build());
            }
        } else {
            super.writeEnd();
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartArray() {
        return this.writeStartArray("");
    }

    @Override
    public JsonGenerator writeStartArray(String name) {
        if (this.stack.isEmpty()) {
            this.builder = JsonUtil.createArrayBuilder();
            this.insertAccumulator(new JsonBuilderGenerator((JsonArrayBuilder)this.builder));
        } else if ("".equals(name)) {
            super.writeStartArray();
        } else {
            super.writeStartArray(name);
        }
        this.stack.push(name);
        return this;
    }

    @Override
    public JsonGenerator writeStartObject() {
        return this.writeStartObject("");
    }

    @Override
    public JsonGenerator writeStartObject(String name) {
        if (this.stack.isEmpty()) {
            this.builder = JsonUtil.createObjectBuilder();
            this.insertAccumulator(new JsonBuilderGenerator((JsonObjectBuilder)this.builder));
        } else if ("".equals(name)) {
            super.writeStartObject();
        } else {
            super.writeStartObject(name);
        }
        this.stack.push(name);
        return this;
    }
}

