/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import net.pincette.json.JsonUtil;
import net.pincette.util.Util;

public class JacksonGenerator
implements JsonGenerator {
    private final com.fasterxml.jackson.core.JsonGenerator generator;
    private Deque<JsonValue.ValueType> stack = new ArrayDeque<JsonValue.ValueType>();

    public JacksonGenerator(com.fasterxml.jackson.core.JsonGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void close() {
        Util.tryToDoRethrow(this.generator::close);
    }

    @Override
    public void flush() {
        Util.tryToDoRethrow(this.generator::flush);
    }

    @Override
    public JsonGenerator write(String name, JsonValue value) {
        this.writeKey(name);
        this.write(value);
        return this;
    }

    @Override
    public JsonGenerator write(String name, String value) {
        Util.tryToDoRethrow(() -> this.generator.writeStringField(name, value));
        return this;
    }

    @Override
    public JsonGenerator write(String name, BigInteger value) {
        this.writeKey(name);
        this.write(value);
        return this;
    }

    @Override
    public JsonGenerator write(String name, BigDecimal value) {
        Util.tryToDoRethrow(() -> this.generator.writeNumberField(name, value));
        return this;
    }

    @Override
    public JsonGenerator write(String name, int value) {
        Util.tryToDoRethrow(() -> this.generator.writeNumberField(name, value));
        return this;
    }

    @Override
    public JsonGenerator write(String name, long value) {
        Util.tryToDoRethrow(() -> this.generator.writeNumberField(name, value));
        return this;
    }

    @Override
    public JsonGenerator write(String name, double value) {
        Util.tryToDoRethrow(() -> this.generator.writeNumberField(name, value));
        return this;
    }

    @Override
    public JsonGenerator write(String name, boolean value) {
        Util.tryToDoRethrow(() -> this.generator.writeBooleanField(name, value));
        return this;
    }

    @Override
    public JsonGenerator write(JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                return this.write(value.asJsonArray());
            }
            case FALSE: {
                return this.write(false);
            }
            case OBJECT: {
                return this.write(value.asJsonObject());
            }
            case NULL: {
                return this.writeNull();
            }
            case NUMBER: {
                return this.write(JsonUtil.asNumber(value));
            }
            case STRING: {
                return this.write(JsonUtil.asString(value).getString());
            }
            case TRUE: {
                return this.write(true);
            }
        }
        return this;
    }

    @Override
    public JsonGenerator write(String value) {
        Util.tryToDoRethrow(() -> this.generator.writeString(value));
        return this;
    }

    @Override
    public JsonGenerator write(BigDecimal value) {
        Util.tryToDoRethrow(() -> this.generator.writeNumber(value));
        return this;
    }

    @Override
    public JsonGenerator write(BigInteger value) {
        Util.tryToDoRethrow(() -> this.generator.writeNumber(value));
        return this;
    }

    @Override
    public JsonGenerator write(int value) {
        Util.tryToDoRethrow(() -> this.generator.writeNumber(value));
        return this;
    }

    @Override
    public JsonGenerator write(long value) {
        Util.tryToDoRethrow(() -> this.generator.writeNumber(value));
        return this;
    }

    @Override
    public JsonGenerator write(double value) {
        return this;
    }

    @Override
    public JsonGenerator write(boolean value) {
        Util.tryToDoRethrow(() -> this.generator.writeBoolean(value));
        return this;
    }

    private JsonGenerator write(JsonNumber value) {
        return value.isIntegral() ? this.write(value.bigIntegerValue()) : this.write(value.bigDecimalValue());
    }

    private JsonGenerator write(JsonArray value) {
        this.writeStartArray();
        value.forEach(this::write);
        this.writeEnd();
        return this;
    }

    private JsonGenerator write(JsonObject value) {
        this.writeStartObject();
        value.forEach(this::write);
        this.writeEnd();
        return this;
    }

    @Override
    public JsonGenerator writeEnd() {
        switch (this.stack.pop()) {
            case ARRAY: {
                Util.tryToDoRethrow(this.generator::writeEndArray);
                return this;
            }
            case OBJECT: {
                Util.tryToDoRethrow(this.generator::writeEndObject);
                return this;
            }
        }
        return this;
    }

    @Override
    public JsonGenerator writeKey(String name) {
        Util.tryToDoRethrow(() -> this.generator.writeFieldName(name));
        return this;
    }

    @Override
    public JsonGenerator writeNull(String name) {
        Util.tryToDoRethrow(() -> this.generator.writeNullField(name));
        return this;
    }

    @Override
    public JsonGenerator writeNull() {
        Util.tryToDoRethrow(this.generator::writeNull);
        return this;
    }

    @Override
    public JsonGenerator writeStartArray() {
        Util.tryToDoRethrow(this.generator::writeStartArray);
        this.stack.push(JsonValue.ValueType.ARRAY);
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(String name) {
        this.writeKey(name);
        this.writeStartArray();
        return this;
    }

    @Override
    public JsonGenerator writeStartObject() {
        Util.tryToDoRethrow(this.generator::writeStartObject);
        this.stack.push(JsonValue.ValueType.OBJECT);
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(String name) {
        this.writeKey(name);
        this.writeStartObject();
        return this;
    }
}

