/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json.filter;

import com.fasterxml.jackson.core.JsonToken;
import java.math.BigDecimal;
import java.util.NoSuchElementException;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import net.pincette.util.Util;

public class JacksonParser
implements JsonParser {
    private final com.fasterxml.jackson.core.JsonParser parser;
    private JsonParser.Event event;
    private JsonToken token;

    public JacksonParser(com.fasterxml.jackson.core.JsonParser parser) {
        this.parser = parser;
    }

    @Override
    public void close() {
        Util.tryToDoRethrow(this.parser::close);
    }

    @Override
    public BigDecimal getBigDecimal() {
        return Util.tryToGetRethrow(this.parser::getDecimalValue).orElse(null);
    }

    @Override
    public int getInt() {
        return Util.tryToGetRethrow(this.parser::getIntValue).orElse(-1);
    }

    @Override
    public JsonLocation getLocation() {
        return null;
    }

    @Override
    public long getLong() {
        return Util.tryToGetRethrow(this.parser::getLongValue).orElse(-1L);
    }

    @Override
    public String getString() {
        return Util.tryToGetRethrow(this.parser::getText).orElse(null);
    }

    @Override
    public boolean hasNext() {
        return this.event != null || (this.event = this.nextEvent()) != null;
    }

    @Override
    public boolean isIntegralNumber() {
        return this.event != null && this.token == JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public JsonParser.Event next() {
        JsonParser.Event result = this.event != null ? this.event : this.nextEvent();
        this.event = null;
        return result;
    }

    private JsonParser.Event nextEvent() {
        this.token = Util.tryToGetRethrow(this.parser::nextToken).orElse(JsonToken.NOT_AVAILABLE);
        switch (this.token) {
            case END_ARRAY: {
                return JsonParser.Event.END_ARRAY;
            }
            case END_OBJECT: {
                return JsonParser.Event.END_OBJECT;
            }
            case FIELD_NAME: {
                return JsonParser.Event.KEY_NAME;
            }
            case NOT_AVAILABLE: {
                return null;
            }
            case VALUE_NULL: {
                return JsonParser.Event.VALUE_NULL;
            }
            case VALUE_TRUE: {
                return JsonParser.Event.VALUE_TRUE;
            }
            case START_ARRAY: {
                return JsonParser.Event.START_ARRAY;
            }
            case VALUE_FALSE: {
                return JsonParser.Event.VALUE_FALSE;
            }
            case START_OBJECT: {
                return JsonParser.Event.START_OBJECT;
            }
            case VALUE_STRING: {
                return JsonParser.Event.VALUE_STRING;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return JsonParser.Event.VALUE_NUMBER;
            }
        }
        throw new NoSuchElementException();
    }
}

