/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json.filter;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.function.Consumer;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import net.pincette.json.JsonUtil;
import net.pincette.json.filter.JsonValueGenerator;
import net.pincette.util.Pair;

public class JsonBuilderGenerator
extends JsonValueGenerator {
    private Object builder;
    private Deque<Pair<String, Object>> builders = new ArrayDeque<Pair<String, Object>>();
    private String lastName;

    public JsonBuilderGenerator() {
    }

    public JsonBuilderGenerator(JsonObjectBuilder builder) {
        this.builders.push(Pair.pair(null, builder));
    }

    public JsonBuilderGenerator(JsonArrayBuilder builder) {
        this.builders.push(Pair.pair(null, builder));
    }

    private static void add(Object parent, Pair<String, Object> builder) {
        if (parent instanceof JsonObjectBuilder) {
            if (builder.first != null) {
                ((JsonObjectBuilder)parent).add((String)builder.first, JsonBuilderGenerator.build(builder.second));
            }
        } else {
            ((JsonArrayBuilder)parent).add(JsonBuilderGenerator.build(builder.second));
        }
    }

    private static JsonStructure build(Object builder) {
        return builder instanceof JsonObjectBuilder ? ((JsonObjectBuilder)builder).build() : ((JsonArrayBuilder)builder).build();
    }

    private Optional<JsonObjectBuilder> asObjectBuilder() {
        return Optional.ofNullable(this.builders.peek()).map(p -> (JsonObjectBuilder)p.second);
    }

    private Optional<JsonArrayBuilder> asArrayBuilder() {
        return Optional.ofNullable(this.builders.peek()).map(p -> (JsonArrayBuilder)p.second);
    }

    public JsonStructure build() {
        if (this.builder == null) {
            throw new IllegalStateException("Object or array is not complete");
        }
        return JsonBuilderGenerator.build(this.builder);
    }

    private void checkNoLastName() {
        if (this.lastName != null) {
            throw new JsonException("writeKey was called without following value");
        }
    }

    @Override
    public JsonGenerator write(JsonValue value) {
        this.writeAnonymous(name -> this.asObjectBuilder().ifPresent(b -> b.add((String)name, value)), () -> this.asArrayBuilder().ifPresent(b -> b.add(value)));
        return this;
    }

    @Override
    public JsonGenerator write(String name, JsonValue value) {
        this.checkNoLastName();
        this.asObjectBuilder().ifPresent(b -> b.add(name, value));
        return this;
    }

    private void writeAnonymous(Consumer<String> objectBuilder, Runnable arrayBuilder) {
        if (this.lastName != null) {
            objectBuilder.accept(this.lastName);
            this.lastName = null;
        } else {
            arrayBuilder.run();
        }
    }

    @Override
    public JsonGenerator writeEnd() {
        Pair<String, Object> bldr = this.builders.pop();
        Optional.ofNullable(this.builders.peek()).map(p -> p.second).ifPresent(b -> JsonBuilderGenerator.add(b, bldr));
        if (this.builders.isEmpty()) {
            this.builder = bldr.second;
        }
        return this;
    }

    @Override
    public JsonGenerator writeKey(String name) {
        this.lastName = name;
        return this;
    }

    @Override
    public JsonGenerator writeNull() {
        this.write(JsonValue.NULL);
        return this;
    }

    @Override
    public JsonGenerator writeNull(String name) {
        this.write(name, JsonValue.NULL);
        return this;
    }

    @Override
    public JsonGenerator writeStartArray() {
        this.builders.push(Pair.pair(this.lastName, JsonUtil.createArrayBuilder()));
        this.lastName = null;
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(String name) {
        this.checkNoLastName();
        this.builders.push(Pair.pair(name, JsonUtil.createArrayBuilder()));
        return this;
    }

    @Override
    public JsonGenerator writeStartObject() {
        this.builders.push(Pair.pair(this.lastName, JsonUtil.createObjectBuilder()));
        this.lastName = null;
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(String name) {
        this.checkNoLastName();
        this.builders.push(Pair.pair(name, JsonUtil.createObjectBuilder()));
        return this;
    }
}

