/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json.filter;

import java.util.Optional;
import javax.json.JsonException;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import net.pincette.json.filter.JsonValueGenerator;

public class JsonGeneratorFilter
extends JsonValueGenerator
implements JsonGenerator {
    private JsonGenerator next;
    private JsonGenerator saved;

    @Override
    public void close() {
        Optional.ofNullable(this.next).ifPresent(JsonGenerator::close);
    }

    @Override
    public void flush() {
        Optional.ofNullable(this.next).ifPresent(JsonGenerator::flush);
    }

    protected void insertAccumulator(JsonGenerator accumulator) {
        this.saved = this.next;
        this.next = accumulator;
    }

    protected JsonGeneratorFilter insertFilter(JsonGeneratorFilter filter) {
        filter.next = this.next;
        this.next = filter;
        return this;
    }

    protected void removeAccumulator() {
        if (this.saved == null) {
            throw new JsonException("No accumulator was inserted");
        }
        this.next = this.saved;
        this.saved = null;
    }

    public JsonGeneratorFilter thenApply(JsonGenerator next) {
        if (this.next == null) {
            this.next = next;
        } else if (this.next instanceof JsonGeneratorFilter) {
            ((JsonGeneratorFilter)this.next).thenApply(next);
        } else {
            throw new JsonException("Unsupported operation");
        }
        return this;
    }

    @Override
    public JsonGenerator write(JsonValue value) {
        if (this.next != null) {
            this.next.write(value);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, JsonValue value) {
        if (this.next != null) {
            this.next.write(name, value);
        }
        return this;
    }

    @Override
    public JsonGenerator writeEnd() {
        if (this.next != null) {
            this.next.writeEnd();
        }
        return this;
    }

    @Override
    public JsonGenerator writeKey(String name) {
        if (this.next != null) {
            this.next.writeKey(name);
        }
        return this;
    }

    @Override
    public JsonGenerator writeNull() {
        if (this.next != null) {
            this.next.writeNull();
        }
        return this;
    }

    @Override
    public JsonGenerator writeNull(String name) {
        if (this.next != null) {
            this.next.writeNull(name);
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartArray() {
        if (this.next != null) {
            this.next.writeStartArray();
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(String name) {
        if (this.next != null) {
            this.next.writeStartArray(name);
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartObject() {
        if (this.next != null) {
            this.next.writeStartObject();
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(String name) {
        if (this.next != null) {
            this.next.writeStartObject(name);
        }
        return this;
    }
}

