/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json.filter;

import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import net.pincette.json.filter.Util;

public class JsonParserWrapper
implements JsonParser {
    private final JsonParser delegate;
    private JsonParser.Event event;

    public JsonParserWrapper(JsonParser delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public JsonArray getArray() {
        return Util.getArray(this);
    }

    @Override
    public Stream<JsonValue> getArrayStream() {
        if (this.event != JsonParser.Event.START_ARRAY) {
            throw new IllegalStateException("In state " + this.event.toString() + " instead of " + JsonParser.Event.START_ARRAY.toString());
        }
        return Util.valueStream(this);
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.delegate.getBigDecimal();
    }

    @Override
    public int getInt() {
        return this.delegate.getInt();
    }

    @Override
    public JsonLocation getLocation() {
        return this.delegate.getLocation();
    }

    @Override
    public long getLong() {
        return this.delegate.getLong();
    }

    @Override
    public JsonObject getObject() {
        return Util.getObject(this);
    }

    @Override
    public Stream<Map.Entry<String, JsonValue>> getObjectStream() {
        return this.getObject().entrySet().stream();
    }

    @Override
    public String getString() {
        return this.delegate.getString();
    }

    @Override
    public JsonValue getValue() {
        return Util.getValue(this.event, this);
    }

    @Override
    public Stream<JsonValue> getValueStream() {
        return Util.valueStream(this);
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public boolean isIntegralNumber() {
        return this.delegate.isIntegralNumber();
    }

    @Override
    public JsonParser.Event next() {
        this.event = this.delegate.next();
        return this.event;
    }

    @Override
    public void skipArray() {
        this.getArray();
    }

    @Override
    public void skipObject() {
        this.getObject();
    }
}

