/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json.filter;

import java.util.function.Supplier;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import net.pincette.json.filter.JsonGeneratorFilter;

public class RemoveEmptyArraysGenerator
extends JsonGeneratorFilter {
    private static final String ANONYMOUS = "anonymous";
    private boolean first = true;
    private String name;
    private boolean pending = false;

    private JsonGenerator flushPending(Supplier<JsonGenerator> then) {
        if (this.name != null) {
            if (this.name.equals(ANONYMOUS)) {
                super.writeStartArray();
            } else {
                super.writeStartArray(this.name);
            }
            this.name = null;
            this.pending = false;
        }
        return then.get();
    }

    private boolean hasRealName() {
        return this.name != null && !this.name.equals(ANONYMOUS);
    }

    private JsonGenerator reset() {
        this.name = null;
        this.pending = false;
        return this;
    }

    private JsonGenerator resetName() {
        this.name = null;
        return this;
    }

    private JsonGenerator setPending() {
        this.pending = true;
        return this;
    }

    @Override
    public JsonGenerator write(JsonValue value) {
        return !this.pending && this.hasRealName() ? this.resetName().write(this.name, value) : this.flushPending(() -> super.write(value));
    }

    @Override
    public JsonGenerator writeEnd() {
        return this.name != null && this.pending ? this.reset() : super.writeEnd();
    }

    @Override
    public JsonGenerator writeKey(String name) {
        this.name = name;
        return this;
    }

    @Override
    public JsonGenerator writeNull() {
        return !this.pending && this.hasRealName() ? this.resetName().writeNull(this.name) : this.flushPending(() -> super.writeNull());
    }

    @Override
    public JsonGenerator writeStartArray() {
        if (this.first) {
            this.first = false;
            return super.writeStartArray();
        }
        if (this.name == null) {
            this.name = ANONYMOUS;
        }
        return this.hasRealName() ? this.writeStartArray(this.name) : this.setPending();
    }

    @Override
    public JsonGenerator writeStartArray(String name) {
        this.name = name;
        return this.setPending();
    }

    @Override
    public JsonGenerator writeStartObject() {
        this.first = false;
        return !this.pending && this.hasRealName() ? this.resetName().writeStartObject(this.name) : this.flushPending(() -> super.writeStartObject());
    }
}

