/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json.filter;

import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import net.pincette.json.filter.JsonGeneratorFilter;

public class RemoveEmptyObjectsGenerator
extends JsonGeneratorFilter {
    private static final String ANONYMOUS = "anonymous";
    private boolean first = true;
    private String name;
    private boolean pending = false;

    private void flushPending() {
        if (this.name != null) {
            if (this.name.equals(ANONYMOUS)) {
                super.writeStartObject();
            } else {
                super.writeStartObject(this.name);
            }
            this.name = null;
            this.pending = false;
        }
    }

    private boolean hasRealName() {
        return this.name != null && !this.name.equals(ANONYMOUS);
    }

    private JsonGenerator reset() {
        this.name = null;
        this.pending = false;
        return this;
    }

    private JsonGenerator setPending() {
        this.pending = true;
        return this;
    }

    @Override
    public JsonGenerator write(JsonValue value) {
        return !this.pending && this.hasRealName() ? this.write(this.name, value) : super.write(value);
    }

    @Override
    public JsonGenerator write(String name, JsonValue value) {
        this.flushPending();
        return super.write(name, value);
    }

    @Override
    public JsonGenerator writeEnd() {
        return this.name != null && this.pending ? this.reset() : super.writeEnd();
    }

    @Override
    public JsonGenerator writeKey(String name) {
        this.name = name;
        return this;
    }

    @Override
    public JsonGenerator writeNull() {
        return !this.pending && this.hasRealName() ? this.writeNull(this.name) : super.writeNull();
    }

    @Override
    public JsonGenerator writeNull(String name) {
        this.flushPending();
        return super.writeNull(name);
    }

    @Override
    public JsonGenerator writeStartArray() {
        this.first = false;
        return !this.pending && this.hasRealName() ? this.writeStartArray(this.name) : super.writeStartArray();
    }

    @Override
    public JsonGenerator writeStartArray(String name) {
        this.flushPending();
        return super.writeStartArray(name);
    }

    @Override
    public JsonGenerator writeStartObject() {
        if (this.first) {
            this.first = false;
            return super.writeStartObject();
        }
        if (this.name == null) {
            this.name = ANONYMOUS;
        }
        return this.hasRealName() ? this.writeStartObject(this.name) : this.setPending();
    }

    @Override
    public JsonGenerator writeStartObject(String name) {
        this.flushPending();
        this.name = name;
        return this.setPending();
    }
}

