/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.json.filter;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import net.pincette.json.JsonUtil;
import net.pincette.json.filter.JsonBuilderGenerator;
import net.pincette.util.StreamUtil;

public class Util {
    private Util() {
    }

    public static JsonGenerator add(JsonParser parser, JsonGenerator generator) {
        while (parser.hasNext()) {
            Util.writeEvent(parser.next(), parser, generator);
        }
        return generator;
    }

    public static JsonGenerator addArray(JsonParser parser, JsonGenerator generator) {
        return Util.addArray(parser, generator, null);
    }

    public static JsonGenerator addArray(JsonParser parser, JsonGenerator generator, String name) {
        return Util.addStructure(parser, generator, name, JsonParser.Event.START_ARRAY, JsonParser.Event.END_ARRAY, generator::writeStartArray, generator::writeStartArray);
    }

    public static JsonGenerator addObject(JsonParser parser, JsonGenerator generator) {
        return Util.addObject(parser, generator, null);
    }

    public static JsonGenerator addObject(JsonParser parser, JsonGenerator generator, String name) {
        return Util.addStructure(parser, generator, name, JsonParser.Event.START_OBJECT, JsonParser.Event.END_OBJECT, generator::writeStartObject, generator::writeStartObject);
    }

    private static JsonGenerator addStructure(JsonParser parser, JsonGenerator generator, String name, JsonParser.Event startEvent, JsonParser.Event endEvent, Runnable start, Consumer<String> startName) {
        ArrayDeque<JsonParser.Event> stack = new ArrayDeque<JsonParser.Event>();
        stack.push(startEvent);
        if (name != null) {
            startName.accept(name);
        } else {
            start.run();
        }
        while (parser.hasNext()) {
            JsonParser.Event e = parser.next();
            Util.writeEvent(e, parser, generator);
            if (e.equals((Object)startEvent)) {
                stack.push(e);
                continue;
            }
            if (!e.equals((Object)endEvent)) continue;
            stack.pop();
            if (!stack.isEmpty()) continue;
            return generator;
        }
        throw new IllegalStateException("Expecting end of object or array");
    }

    public static JsonArray getArray(JsonParser parser) {
        return Optional.of(new JsonBuilderGenerator()).map(generator -> Util.addArray(parser, generator)).map(generator -> ((JsonBuilderGenerator)generator).build()).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).orElseThrow(IllegalStateException::new);
    }

    public static JsonObject getObject(JsonParser parser) {
        return Optional.of(new JsonBuilderGenerator()).map(generator -> Util.addObject(parser, generator)).map(generator -> ((JsonBuilderGenerator)generator).build()).filter(JsonUtil::isObject).map(JsonValue::asJsonObject).orElseThrow(IllegalStateException::new);
    }

    public static JsonValue getValue(JsonParser.Event e, JsonParser parser) {
        switch (e) {
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_STRING: {
                return JsonUtil.createValue(parser.getString());
            }
            case START_ARRAY: {
                return Util.getArray(parser);
            }
            case START_OBJECT: {
                return Util.getObject(parser);
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_NUMBER: {
                return JsonUtil.createValue(parser.getBigDecimal());
            }
        }
        return null;
    }

    public static Stream<JsonValue> stream(JsonParser parser) {
        Function<JsonParser.Event, Stream> contents = event -> event == JsonParser.Event.START_OBJECT ? Stream.of(Util.getObject(parser)) : Util.valueStream(parser);
        return !parser.hasNext() ? Stream.empty() : contents.apply(parser.next());
    }

    public static Stream<JsonValue> valueStream(final JsonParser parser) {
        return StreamUtil.stream(new Iterator<JsonValue>(){
            JsonParser.Event nextEvent;

            private JsonParser.Event getNext() {
                return this.nextEvent != null && this.nextEvent != JsonParser.Event.END_ARRAY ? this.nextEvent : null;
            }

            @Override
            public boolean hasNext() {
                this.nextEvent = parser.hasNext() ? parser.next() : null;
                return this.getNext() != null;
            }

            @Override
            public JsonValue next() {
                return Optional.ofNullable(this.getNext()).map(e -> Util.getValue(e, parser)).orElseThrow(NoSuchElementException::new);
            }
        });
    }

    public static JsonGenerator writeEvent(JsonParser.Event e, JsonParser parser, JsonGenerator generator) {
        switch (e) {
            case END_ARRAY: 
            case END_OBJECT: {
                generator.writeEnd();
                break;
            }
            case KEY_NAME: {
                generator.writeKey(parser.getString());
                break;
            }
            case START_ARRAY: {
                generator.writeStartArray();
                break;
            }
            case START_OBJECT: {
                generator.writeStartObject();
                break;
            }
            case VALUE_FALSE: {
                generator.write(false);
                break;
            }
            case VALUE_NULL: {
                generator.writeNull();
                break;
            }
            case VALUE_NUMBER: {
                generator.write(parser.getBigDecimal());
                break;
            }
            case VALUE_STRING: {
                generator.write(parser.getString());
                break;
            }
            case VALUE_TRUE: {
                generator.write(true);
            }
        }
        return generator;
    }
}

