/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.json.JsonNumber;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;

class Arithmetic {
    private static final MathContext PRECISION = new MathContext(16);

    private Arithmetic() {
    }

    static Implementation abs(JsonValue value, Features features) {
        return Expression.bigMath(value, BigDecimal::abs, features);
    }

    static Implementation add(JsonValue value, Features features) {
        List<Implementation> functions = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementations(functions, json, vars).filter(Arithmetic::isAddArray).map(values -> Arithmetic.getInstant(values).map(instant -> Arithmetic.addToInstant(instant, values)).orElseGet(() -> Arithmetic.sum(values))).orElse(JsonValue.NULL);
    }

    private static JsonValue addToInstant(Instant instant, List<JsonValue> values) {
        return JsonUtil.createValue(values.stream().filter(JsonUtil::isNumber).map(JsonUtil::asNumber).map(JsonNumber::longValue).reduce(instant, Instant::plusMillis, (i1, i2) -> i1).toString());
    }

    static Implementation ceil(JsonValue value, Features features) {
        return Arithmetic.toLong(Expression.math(value, Math::ceil, features));
    }

    static Implementation divide(JsonValue value, Features features) {
        return Expression.bigMathTwo(value, (v1, v2) -> v1.divide((BigDecimal)v2, PRECISION), false, features);
    }

    static Implementation exp(JsonValue value, Features features) {
        return Expression.math(value, Math::exp, features);
    }

    static Implementation floor(JsonValue value, Features features) {
        return Arithmetic.toLong(Expression.math(value, Math::floor, features));
    }

    private static Optional<Instant> getInstant(List<JsonValue> addArray) {
        return addArray.stream().filter(JsonUtil::isInstant).map(JsonUtil::asInstant).findFirst();
    }

    private static boolean isAddArray(List<JsonValue> array) {
        List values = array.stream().filter(v -> !JsonUtil.isNumber(v)).collect(Collectors.toList());
        return values.isEmpty() || values.size() == 1 && JsonUtil.isInstant((JsonValue)values.get(0));
    }

    static Implementation ln(JsonValue value, Features features) {
        return Expression.math(value, Math::log, features);
    }

    static Implementation log(JsonValue value, Features features) {
        return Expression.mathTwo(value, (v1, v2) -> Math.log(v1) / Math.log(v2), false, features);
    }

    static Implementation log10(JsonValue value, Features features) {
        return Expression.math(value, Math::log10, features);
    }

    static Implementation mod(JsonValue value, Features features) {
        return Expression.bigMathTwo(value, BigDecimal::remainder, false, features);
    }

    static Implementation multiply(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars).map(Arithmetic::multiply).orElse(JsonValue.NULL);
    }

    private static JsonValue multiply(List<JsonValue> values) {
        return Arithmetic.setOp(values, BigDecimal::multiply);
    }

    static Implementation pow(JsonValue value, Features features) {
        return Expression.bigMathTwo(value, (v1, v2) -> Arithmetic.pow(v1, v2.intValue()), false, features);
    }

    private static BigDecimal pow(BigDecimal value, int exp) {
        return exp < 0 ? new BigDecimal(1).divide(value.pow(Math.abs(exp)), PRECISION) : value.pow(exp);
    }

    static Implementation round(JsonValue value, Features features) {
        return Arithmetic.toLong(Expression.mathTwo(value, (v1, v2) -> Arithmetic.round(v1, v2 != null ? v2.intValue() : 0), true, features));
    }

    private static double round(double value, int place) {
        double shift = Math.pow(10.0, Math.abs(place));
        return place > 0 ? (double)Math.round(value * shift) / shift : (double)Math.round(value / shift) * shift;
    }

    private static JsonValue setOp(List<JsonValue> values, BinaryOperator<BigDecimal> combiner) {
        return values.stream().filter(JsonUtil::isNumber).map(JsonUtil::asNumber).map(JsonNumber::bigDecimalValue).reduce(combiner).map(JsonUtil::createValue).orElse(JsonValue.NULL);
    }

    static Implementation sqrt(JsonValue value, Features features) {
        return Expression.math(value, Math::sqrt, features);
    }

    static Implementation subtract(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementationsNum(implementations, json, vars, 2).map(values -> Arithmetic.subtract((JsonValue)values.get(0), (JsonValue)values.get(1))).orElse(JsonValue.NULL);
    }

    private static JsonValue subtract(JsonValue v1, JsonValue v2) {
        Supplier<JsonValue> tryDates = () -> JsonUtil.isInstant(v2) ? JsonUtil.createValue(Duration.between(JsonUtil.asInstant(v2), JsonUtil.asInstant(v1)).toMillis()) : JsonUtil.createValue(JsonUtil.asInstant(v1).minusMillis(JsonUtil.asLong(v2)).toString());
        return JsonUtil.isNumber(v1) && JsonUtil.isNumber(v2) ? JsonUtil.createValue(JsonUtil.asNumber(v1).bigDecimalValue().subtract(JsonUtil.asNumber(v2).bigDecimalValue())) : Optional.of(v1).filter(v -> JsonUtil.isInstant(v) && (JsonUtil.isInstant(v2) || JsonUtil.isLong(v2))).map(v -> (JsonValue)tryDates.get()).orElse(JsonValue.NULL);
    }

    private static JsonValue sum(List<JsonValue> values) {
        return Arithmetic.setOp(values, BigDecimal::add);
    }

    private static Implementation toLong(Implementation implementation) {
        return (json, vars) -> Arithmetic.toLong((JsonValue)implementation.apply(json, vars));
    }

    private static JsonValue toLong(JsonValue value) {
        return JsonUtil.isLong(value) ? JsonUtil.createValue(JsonUtil.asNumber(value).longValue()) : value;
    }

    static Implementation trunc(JsonValue value, Features features) {
        return Arithmetic.toLong(Expression.mathTwo(value, (v1, v2) -> Arithmetic.trunc(v1, v2 != null ? v2.intValue() : 0), true, features));
    }

    private static double trunc(double value, int place) {
        double shift = Math.pow(10.0, Math.abs(place));
        return place > 0 ? (double)((long)(value * shift)) / shift : (double)((long)(value / shift)) * shift;
    }
}

