/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.util.List;
import java.util.function.BiFunction;
import javax.json.JsonValue;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;

class Booleans {
    private Booleans() {
    }

    static Implementation and(JsonValue value, Features features) {
        return Booleans.combine(value, true, (r, v) -> r != false && !Expression.isFalse(v), features);
    }

    private static Implementation combine(JsonValue value, boolean initial, BiFunction<Boolean, JsonValue, Boolean> combiner, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars).map(values -> values.stream().reduce(initial, combiner, (r1, r2) -> r1)).map(result -> result != false ? JsonValue.TRUE : JsonValue.FALSE).orElse(JsonValue.NULL);
    }

    private static JsonValue invert(JsonValue value) {
        return Expression.isFalse(value) ? JsonValue.TRUE : JsonValue.FALSE;
    }

    static Implementation or(JsonValue value, Features features) {
        return Booleans.combine(value, false, (r, v) -> r != false || !Expression.isFalse(v), features);
    }

    static Implementation not(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementationsNum(implementations, json, vars, 1).map(values -> (JsonValue)values.get(0)).map(Booleans::invert).orElse(JsonValue.NULL);
    }
}

