/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.time.Instant;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import org.bson.BsonArray;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonNumber;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.conversions.Bson;
import org.bson.io.BasicOutputBuffer;

public class BsonUtil {
    private BsonUtil() {
    }

    public static JsonValue fromBson(BsonValue bson) {
        switch (bson.getBsonType()) {
            case ARRAY: {
                return BsonUtil.fromBson(bson.asArray());
            }
            case BOOLEAN: {
                return bson.asBoolean().getValue() ? JsonValue.TRUE : JsonValue.FALSE;
            }
            case DATE_TIME: {
                return BsonUtil.fromBson(bson.asDateTime());
            }
            case DOCUMENT: {
                return BsonUtil.fromBson(bson.asDocument());
            }
            case DOUBLE: {
                return BsonUtil.fromBson(bson.asDouble());
            }
            case INT32: {
                return BsonUtil.fromBson(bson.asInt32());
            }
            case INT64: {
                return BsonUtil.fromBson(bson.asInt64());
            }
            case NULL: {
                return JsonValue.NULL;
            }
            case REGULAR_EXPRESSION: {
                return BsonUtil.fromBson(bson.asRegularExpression());
            }
            case STRING: {
                return BsonUtil.fromBson(bson.asString());
            }
            case TIMESTAMP: {
                return BsonUtil.fromBson(bson.asTimestamp());
            }
        }
        return null;
    }

    public static JsonArray fromBson(BsonArray array) {
        return array.stream().map(BsonUtil::fromBson).reduce(JsonUtil.createArrayBuilder(), JsonArrayBuilder::add, (b1, b2) -> b1).build();
    }

    public static JsonObject fromBson(BsonDocument bson) {
        return bson.entrySet().stream().reduce(JsonUtil.createObjectBuilder(), (b, e) -> b.add((String)e.getKey(), BsonUtil.fromBson((BsonValue)e.getValue())), (b1, b2) -> b1).build();
    }

    public static JsonNumber fromBson(BsonInt32 bson) {
        return JsonUtil.asNumber(JsonUtil.createValue(bson.getValue()));
    }

    public static JsonNumber fromBson(BsonInt64 bson) {
        return JsonUtil.asNumber(JsonUtil.createValue(bson.getValue()));
    }

    public static JsonNumber fromBson(BsonDouble bson) {
        return JsonUtil.asNumber(JsonUtil.createValue(bson.getValue()));
    }

    public static JsonString fromBson(BsonDateTime bson) {
        return JsonUtil.asString(JsonUtil.createValue(Instant.ofEpochMilli(bson.getValue()).toString()));
    }

    public static JsonObject fromBson(BsonRegularExpression bson) {
        return JsonUtil.createObjectBuilder().add("$regex", bson.getPattern()).add("$options", bson.getOptions()).build();
    }

    public static JsonString fromBson(BsonString bson) {
        return JsonUtil.asString(JsonUtil.createValue(bson.getValue()));
    }

    public static JsonString fromBson(BsonTimestamp bson) {
        return JsonUtil.asString(JsonUtil.createValue(Instant.ofEpochSecond(bson.getTime()).toString()));
    }

    public static BsonValue fromJson(JsonValue json) {
        switch (json.getValueType()) {
            case ARRAY: {
                return BsonUtil.fromJson(json.asJsonArray());
            }
            case FALSE: {
                return BsonBoolean.FALSE;
            }
            case NULL: {
                return BsonNull.VALUE;
            }
            case NUMBER: {
                return BsonUtil.fromJson(JsonUtil.asNumber(json));
            }
            case OBJECT: {
                return BsonUtil.fromJson(json.asJsonObject());
            }
            case STRING: {
                return BsonUtil.fromJson(JsonUtil.asString(json));
            }
            case TRUE: {
                return BsonBoolean.TRUE;
            }
        }
        return null;
    }

    public static BsonArray fromJson(JsonArray array) {
        return new BsonArray(array.stream().map(BsonUtil::fromJson).collect(Collectors.toList()));
    }

    public static BsonDocument fromJson(JsonObject json) {
        return json.entrySet().stream().reduce(new BsonDocument(), (d, e) -> d.append((String)e.getKey(), BsonUtil.fromJson((JsonValue)e.getValue())), (d1, d2) -> d1);
    }

    public static BsonNumber fromJson(JsonNumber json) {
        return json.isIntegral() ? new BsonInt64(json.longValue()) : new BsonDouble(json.doubleValue());
    }

    public static BsonString fromJson(JsonString json) {
        return new BsonString(json.getString());
    }

    public static BsonDocument toBsonDocument(Bson bson) {
        return bson.toBsonDocument(BsonDocument.class, CodecRegistries.fromProviders(new BsonValueCodecProvider(), new ValueCodecProvider(), new DocumentCodecProvider()));
    }

    public static byte[] toBytes(BsonDocument document) {
        BasicOutputBuffer out = new BasicOutputBuffer();
        new BsonDocumentCodec().encode((BsonWriter)new BsonBinaryWriter(out), document, EncoderContext.builder().build());
        return out.toByteArray();
    }

    public static Document toDocument(BsonDocument document) {
        return new Document(document.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }
}

