/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.util.List;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;
import net.pincette.mongo.Util;

class Cmp {
    private Cmp() {
    }

    static Implementation cmp(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementationsNum(implementations, json, vars, 2).map(values -> Cmp.cmp((JsonValue)values.get(0), (JsonValue)values.get(1))).orElse(JsonValue.NULL);
    }

    private static JsonValue cmp(JsonValue v1, JsonValue v2) {
        return JsonUtil.createValue(Util.compare(v1, v2));
    }

    static boolean comparable(JsonValue v1, JsonValue v2) {
        return JsonUtil.isBoolean(v1) && JsonUtil.isBoolean(v2) || JsonUtil.isNumber(v1) && JsonUtil.isNumber(v2) || JsonUtil.isString(v1) && JsonUtil.isString(v2);
    }

    static int compare(JsonValue v1, JsonValue v2) {
        if (v2.equals(JsonValue.NULL)) {
            return 1;
        }
        switch (v1.getValueType()) {
            case FALSE: {
                return v2.equals(JsonValue.FALSE) ? 0 : -1;
            }
            case NULL: {
                return -1;
            }
            case NUMBER: {
                return Cmp.compareNumbers(v1, v2);
            }
            case STRING: {
                return Cmp.compareStrings(v1, v2);
            }
            case TRUE: {
                return v2.equals(JsonValue.TRUE) ? 0 : 1;
            }
        }
        return 0;
    }

    static int compareNumbers(JsonValue v1, JsonValue v2) {
        return JsonUtil.asNumber(v1).bigDecimalValue().compareTo(JsonUtil.asNumber(v2).bigDecimalValue());
    }

    static int compareStrings(JsonValue v1, JsonValue v2) {
        return JsonUtil.asString(v1).getString().compareTo(JsonUtil.asString(v2).getString());
    }
}

