/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.pincette.rs.Util;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

public class Collection {
    private Collection() {
    }

    public static <D> CompletionStage<List<D>> aggregate(MongoCollection<D> collection, List<? extends Bson> pipeline, UnaryOperator<AggregatePublisher<D>> setParameters) {
        return Collection.execList(collection, c -> Collection.aggregatePub(c.aggregate(pipeline), setParameters));
    }

    public static <D> CompletionStage<List<D>> aggregate(MongoCollection<D> collection, ClientSession session, List<? extends Bson> pipeline, UnaryOperator<AggregatePublisher<D>> setParameters) {
        return Collection.execList(collection, c -> Collection.aggregatePub(c.aggregate(session, pipeline), setParameters));
    }

    public static <T, D> CompletionStage<List<T>> aggregate(MongoCollection<D> collection, List<? extends Bson> pipeline, Class<T> resultClass, UnaryOperator<AggregatePublisher<T>> setParameters) {
        return Collection.execList(collection, c -> Collection.aggregatePub(c.aggregate(pipeline, resultClass), setParameters));
    }

    public static <T, D> CompletionStage<List<T>> aggregate(MongoCollection<D> collection, ClientSession session, List<? extends Bson> pipeline, Class<T> resultClass, UnaryOperator<AggregatePublisher<T>> setParameters) {
        return Collection.execList(collection, c -> Collection.aggregatePub(c.aggregate(session, pipeline, resultClass), setParameters));
    }

    private static <T> AggregatePublisher<T> aggregatePub(AggregatePublisher<T> pub, UnaryOperator<AggregatePublisher<T>> setParameters) {
        return setParameters != null ? (AggregatePublisher)setParameters.apply(pub) : pub;
    }

    public static <D> CompletionStage<BulkWriteResult> bulkWrite(MongoCollection<D> collection, List<? extends WriteModel<? extends D>> requests) {
        return Collection.exec(collection, c -> c.bulkWrite(requests));
    }

    public static <D> CompletionStage<BulkWriteResult> bulkWrite(MongoCollection<D> collection, ClientSession session, List<? extends WriteModel<? extends D>> requests) {
        return Collection.exec(collection, c -> c.bulkWrite(session, requests));
    }

    public static <D> CompletionStage<BulkWriteResult> bulkWrite(MongoCollection<D> collection, List<? extends WriteModel<? extends D>> requests, BulkWriteOptions options) {
        return Collection.exec(collection, c -> c.bulkWrite(requests, options));
    }

    public static <D> CompletionStage<BulkWriteResult> bulkWrite(MongoCollection<D> collection, ClientSession session, List<? extends WriteModel<? extends D>> requests, BulkWriteOptions options) {
        return Collection.exec(collection, c -> c.bulkWrite(session, requests, options));
    }

    public static <D> CompletionStage<Long> countDocuments(MongoCollection<D> collection) {
        return Collection.exec(collection, MongoCollection::countDocuments);
    }

    public static <D> CompletionStage<Long> countDocuments(MongoCollection<D> collection, ClientSession session) {
        return Collection.exec(collection, c -> c.countDocuments(session));
    }

    public static <D> CompletionStage<Long> countDocuments(MongoCollection<D> collection, Bson filter) {
        return Collection.exec(collection, c -> c.countDocuments(filter));
    }

    public static <D> CompletionStage<Long> countDocuments(MongoCollection<D> collection, ClientSession session, Bson filter) {
        return Collection.exec(collection, c -> c.countDocuments(session, filter));
    }

    public static <D> CompletionStage<Long> countDocuments(MongoCollection<D> collection, Bson filter, CountOptions options) {
        return Collection.exec(collection, c -> c.countDocuments(filter, options));
    }

    public static <D> CompletionStage<Long> countDocuments(MongoCollection<D> collection, ClientSession session, Bson filter, CountOptions options) {
        return Collection.exec(collection, c -> c.countDocuments(session, filter, options));
    }

    public static <D> CompletionStage<DeleteResult> deleteMany(MongoCollection<D> collection, Bson filter) {
        return Collection.exec(collection, c -> c.deleteMany(filter));
    }

    public static <D> CompletionStage<DeleteResult> deleteMany(MongoCollection<D> collection, ClientSession session, Bson filter) {
        return Collection.exec(collection, c -> c.deleteMany(session, filter));
    }

    public static <D> CompletionStage<DeleteResult> deleteMany(MongoCollection<D> collection, Bson filter, DeleteOptions options) {
        return Collection.exec(collection, c -> c.deleteMany(filter, options));
    }

    public static <D> CompletionStage<DeleteResult> deleteMany(MongoCollection<D> collection, ClientSession session, Bson filter, DeleteOptions options) {
        return Collection.exec(collection, c -> c.deleteMany(session, filter, options));
    }

    public static <D> CompletionStage<DeleteResult> deleteOne(MongoCollection<D> collection, Bson filter) {
        return Collection.exec(collection, c -> c.deleteOne(filter));
    }

    public static <D> CompletionStage<DeleteResult> deleteOne(MongoCollection<D> collection, ClientSession session, Bson filter) {
        return Collection.exec(collection, c -> c.deleteOne(session, filter));
    }

    public static <D> CompletionStage<DeleteResult> deleteOne(MongoCollection<D> collection, Bson filter, DeleteOptions options) {
        return Collection.exec(collection, c -> c.deleteOne(filter, options));
    }

    public static <D> CompletionStage<DeleteResult> deleteOne(MongoCollection<D> collection, ClientSession session, Bson filter, DeleteOptions options) {
        return Collection.exec(collection, c -> c.deleteOne(session, filter, options));
    }

    public static <T, D> CompletionStage<List<T>> distinct(MongoCollection<D> collection, String fieldName, Class<T> resultClass, UnaryOperator<DistinctPublisher<T>> setParameters) {
        return Collection.execList(collection, c -> Collection.distinctPub(c.distinct(fieldName, resultClass), setParameters));
    }

    public static <T, D> CompletionStage<List<T>> distinct(MongoCollection<D> collection, ClientSession session, String fieldName, Class<T> resultClass, UnaryOperator<DistinctPublisher<T>> setParameters) {
        return Collection.execList(collection, c -> Collection.distinctPub(c.distinct(session, fieldName, resultClass), setParameters));
    }

    public static <T, D> CompletionStage<List<T>> distinct(MongoCollection<D> collection, String fieldName, Bson filter, Class<T> resultClass, UnaryOperator<DistinctPublisher<T>> setParameters) {
        return Collection.execList(collection, c -> Collection.distinctPub(c.distinct(fieldName, filter, resultClass), setParameters));
    }

    public static <T, D> CompletionStage<List<T>> distinct(MongoCollection<D> collection, ClientSession session, String fieldName, Bson filter, Class<T> resultClass, UnaryOperator<DistinctPublisher<T>> setParameters) {
        return Collection.execList(collection, c -> Collection.distinctPub(c.distinct(session, fieldName, filter, resultClass), setParameters));
    }

    private static <T> DistinctPublisher<T> distinctPub(DistinctPublisher<T> pub, UnaryOperator<DistinctPublisher<T>> setParameters) {
        return setParameters != null ? (DistinctPublisher)setParameters.apply(pub) : pub;
    }

    public static <D> CompletionStage<Long> estimatedDocumentCount(MongoCollection<D> collection) {
        return Collection.exec(collection, MongoCollection::estimatedDocumentCount);
    }

    public static <D> CompletionStage<Long> estimatedDocumentCount(MongoCollection<D> collection, EstimatedDocumentCountOptions options) {
        return Collection.exec(collection, c -> c.estimatedDocumentCount(options));
    }

    public static <T, D> CompletionStage<T> exec(MongoCollection<D> collection, Function<MongoCollection<D>, Publisher<T>> op) {
        return Util.asValueAsync(op.apply(collection));
    }

    public static <T, D> CompletionStage<List<T>> execList(MongoCollection<D> collection, Function<MongoCollection<D>, Publisher<T>> op) {
        return Util.asListAsync(op.apply(collection));
    }

    public static <D> CompletionStage<List<D>> find(MongoCollection<D> collection, UnaryOperator<FindPublisher<D>> setParameters) {
        return Collection.execList(collection, c -> Collection.findPub(c.find(), setParameters));
    }

    public static <D> CompletionStage<List<D>> find(MongoCollection<D> collection, ClientSession session, UnaryOperator<FindPublisher<D>> setParameters) {
        return Collection.execList(collection, c -> Collection.findPub(c.find(session), setParameters));
    }

    public static <D> CompletionStage<List<D>> find(MongoCollection<D> collection, Bson filter, UnaryOperator<FindPublisher<D>> setParameters) {
        return Collection.execList(collection, c -> Collection.findPub(c.find(filter), setParameters));
    }

    public static <D> CompletionStage<List<D>> find(MongoCollection<D> collection, ClientSession session, Bson filter, UnaryOperator<FindPublisher<D>> setParameters) {
        return Collection.execList(collection, c -> Collection.findPub(c.find(session, filter), setParameters));
    }

    public static <T, D> CompletionStage<List<T>> find(MongoCollection<D> collection, Class<T> resultClass, UnaryOperator<FindPublisher<T>> setParameters) {
        return Collection.execList(collection, c -> Collection.findPub(c.find(resultClass), setParameters));
    }

    public static <T, D> CompletionStage<List<T>> find(MongoCollection<D> collection, ClientSession session, Class<T> resultClass, UnaryOperator<FindPublisher<T>> setParameters) {
        return Collection.execList(collection, c -> Collection.findPub(c.find(session, resultClass), setParameters));
    }

    public static <T, D> CompletionStage<List<T>> find(MongoCollection<D> collection, Bson filter, Class<T> resultClass, UnaryOperator<FindPublisher<T>> setParameters) {
        return Collection.execList(collection, c -> Collection.findPub(c.find(filter, resultClass), setParameters));
    }

    public static <T, D> CompletionStage<List<T>> find(MongoCollection<D> collection, ClientSession session, Bson filter, Class<T> resultClass, UnaryOperator<FindPublisher<T>> setParameters) {
        return Collection.execList(collection, c -> Collection.findPub(c.find(session, filter, resultClass), setParameters));
    }

    public static <T, D> CompletionStage<Optional<T>> findOne(MongoCollection<D> collection, Bson filter, Class<T> resultClass, UnaryOperator<FindPublisher<T>> setParameters) {
        return Collection.find(collection, filter, resultClass, setParameters).thenApply(Collection::justOne);
    }

    public static <T, D> CompletionStage<Optional<T>> findOne(MongoCollection<D> collection, ClientSession session, Bson filter, Class<T> resultClass, UnaryOperator<FindPublisher<T>> setParameters) {
        return Collection.find(collection, session, filter, resultClass, setParameters).thenApply(Collection::justOne);
    }

    private static <T> FindPublisher<T> findPub(FindPublisher<T> pub, UnaryOperator<FindPublisher<T>> setParameters) {
        return setParameters != null ? (FindPublisher)setParameters.apply(pub) : pub;
    }

    public static <D> CompletionStage<D> findOneAndDelete(MongoCollection<D> collection, Bson filter) {
        return Collection.exec(collection, c -> c.findOneAndDelete(filter));
    }

    public static <D> CompletionStage<D> findOneAndDelete(MongoCollection<D> collection, ClientSession session, Bson filter) {
        return Collection.exec(collection, c -> c.findOneAndDelete(session, filter));
    }

    public static <D> CompletionStage<D> findOneAndDelete(MongoCollection<D> collection, Bson filter, FindOneAndDeleteOptions options) {
        return Collection.exec(collection, c -> c.findOneAndDelete(filter, options));
    }

    public static <D> CompletionStage<D> findOneAndDelete(MongoCollection<D> collection, ClientSession session, Bson filter, FindOneAndDeleteOptions options) {
        return Collection.exec(collection, c -> c.findOneAndDelete(session, filter, options));
    }

    public static <D> CompletionStage<D> findOneAndReplace(MongoCollection<D> collection, Bson filter, D replacement) {
        return Collection.exec(collection, c -> c.findOneAndReplace(filter, replacement));
    }

    public static <D> CompletionStage<D> findOneAndReplace(MongoCollection<D> collection, ClientSession session, Bson filter, D replacement) {
        return Collection.exec(collection, c -> c.findOneAndReplace(session, filter, replacement));
    }

    public static <D> CompletionStage<D> findOneAndReplace(MongoCollection<D> collection, Bson filter, D replacement, FindOneAndReplaceOptions options) {
        return Collection.exec(collection, c -> c.findOneAndReplace(filter, replacement, options));
    }

    public static <D> CompletionStage<D> findOneAndReplace(MongoCollection<D> collection, ClientSession session, Bson filter, D replacement, FindOneAndReplaceOptions options) {
        return Collection.exec(collection, c -> c.findOneAndReplace(session, filter, replacement, options));
    }

    public static <D> CompletionStage<D> findOneAndUpdate(MongoCollection<D> collection, Bson filter, Bson update) {
        return Collection.exec(collection, c -> c.findOneAndUpdate(filter, update));
    }

    public static <D> CompletionStage<D> findOneAndUpdate(MongoCollection<D> collection, ClientSession session, Bson filter, Bson update) {
        return Collection.exec(collection, c -> c.findOneAndUpdate(session, filter, update));
    }

    public static <D> CompletionStage<D> findOneAndUpdate(MongoCollection<D> collection, Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return Collection.exec(collection, c -> c.findOneAndUpdate(filter, update, options));
    }

    public static <D> CompletionStage<D> findOneAndUpdate(MongoCollection<D> collection, ClientSession session, Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return Collection.exec(collection, c -> c.findOneAndUpdate(session, filter, update, options));
    }

    public static <D> CompletionStage<D> findOneAndUpdate(MongoCollection<D> collection, Bson filter, List<? extends Bson> update) {
        return Collection.exec(collection, c -> c.findOneAndUpdate(filter, update));
    }

    public static <D> CompletionStage<D> findOneAndUpdate(MongoCollection<D> collection, ClientSession session, Bson filter, List<? extends Bson> update) {
        return Collection.exec(collection, c -> c.findOneAndUpdate(session, filter, update));
    }

    public static <D> CompletionStage<D> findOneAndUpdate(MongoCollection<D> collection, Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return Collection.exec(collection, c -> c.findOneAndUpdate(filter, update, options));
    }

    public static <D> CompletionStage<D> findOneAndUpdate(MongoCollection<D> collection, ClientSession session, Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return Collection.exec(collection, c -> c.findOneAndUpdate(session, filter, update, options));
    }

    public static <D> CompletionStage<InsertManyResult> insertMany(MongoCollection<D> collection, List<? extends D> documents) {
        return Collection.exec(collection, c -> c.insertMany(documents));
    }

    public static <D> CompletionStage<InsertManyResult> insertMany(MongoCollection<D> collection, ClientSession session, List<? extends D> documents) {
        return Collection.exec(collection, c -> c.insertMany(session, documents));
    }

    public static <D> CompletionStage<InsertManyResult> insertMany(MongoCollection<D> collection, List<? extends D> documents, InsertManyOptions options) {
        return Collection.exec(collection, c -> c.insertMany(documents, options));
    }

    public static <D> CompletionStage<InsertManyResult> insertMany(MongoCollection<D> collection, ClientSession session, List<? extends D> documents, InsertManyOptions options) {
        return Collection.exec(collection, c -> c.insertMany(session, documents, options));
    }

    public static <D> CompletionStage<InsertOneResult> insertOne(MongoCollection<D> collection, D document) {
        return Collection.exec(collection, c -> c.insertOne(document));
    }

    public static <D> CompletionStage<InsertOneResult> insertOne(MongoCollection<D> collection, ClientSession session, D document) {
        return Collection.exec(collection, c -> c.insertOne(session, document));
    }

    public static <D> CompletionStage<InsertOneResult> insertOne(MongoCollection<D> collection, D document, InsertOneOptions options) {
        return Collection.exec(collection, c -> c.insertOne(document, options));
    }

    public static <D> CompletionStage<InsertOneResult> insertOne(MongoCollection<D> collection, ClientSession session, D document, InsertOneOptions options) {
        return Collection.exec(collection, c -> c.insertOne(session, document, options));
    }

    private static <T> Optional<T> justOne(List<T> list) {
        return Optional.of(list).filter(l -> l.size() == 1).map(l -> l.get(0));
    }

    public static <D> CompletionStage<List<D>> mapReduce(MongoCollection<D> collection, String mapFunction, String reduceFunction, UnaryOperator<MapReducePublisher<D>> setParameters) {
        return Collection.execList(collection, c -> Collection.mapReducePub(c.mapReduce(mapFunction, reduceFunction), setParameters));
    }

    public static <D> CompletionStage<List<D>> mapReduce(MongoCollection<D> collection, ClientSession session, String mapFunction, String reduceFunction, UnaryOperator<MapReducePublisher<D>> setParameters) {
        return Collection.execList(collection, c -> Collection.mapReducePub(c.mapReduce(session, mapFunction, reduceFunction), setParameters));
    }

    public static <T, D> CompletionStage<List<T>> mapReduce(MongoCollection<D> collection, String mapFunction, String reduceFunction, Class<T> resultClass, UnaryOperator<MapReducePublisher<T>> setParameters) {
        return Collection.execList(collection, c -> Collection.mapReducePub(c.mapReduce(mapFunction, reduceFunction, resultClass), setParameters));
    }

    public static <T, D> CompletionStage<List<T>> mapReduce(MongoCollection<D> collection, ClientSession session, String mapFunction, String reduceFunction, Class<T> resultClass, UnaryOperator<MapReducePublisher<T>> setParameters) {
        return Collection.execList(collection, c -> Collection.mapReducePub(c.mapReduce(session, mapFunction, reduceFunction, resultClass), setParameters));
    }

    private static <T> MapReducePublisher<T> mapReducePub(MapReducePublisher<T> pub, UnaryOperator<MapReducePublisher<T>> setParameters) {
        return setParameters != null ? (MapReducePublisher)setParameters.apply(pub) : pub;
    }

    public static <D> CompletionStage<UpdateResult> replaceOne(MongoCollection<D> collection, Bson filter, D replacement) {
        return Collection.exec(collection, c -> c.replaceOne(filter, replacement));
    }

    public static <D> CompletionStage<UpdateResult> replaceOne(MongoCollection<D> collection, ClientSession session, Bson filter, D replacement) {
        return Collection.exec(collection, c -> c.replaceOne(session, filter, replacement));
    }

    public static <D> CompletionStage<UpdateResult> replaceOne(MongoCollection<D> collection, Bson filter, D replacement, ReplaceOptions options) {
        return Collection.exec(collection, c -> c.replaceOne(filter, replacement, options));
    }

    public static <D> CompletionStage<UpdateResult> replaceOne(MongoCollection<D> collection, ClientSession session, Bson filter, D replacement, ReplaceOptions options) {
        return Collection.exec(collection, c -> c.replaceOne(session, filter, replacement, options));
    }

    public static <D> CompletionStage<UpdateResult> updateMany(MongoCollection<D> collection, Bson filter, Bson update) {
        return Collection.exec(collection, c -> c.updateMany(filter, update));
    }

    public static <D> CompletionStage<UpdateResult> updateMany(MongoCollection<D> collection, ClientSession session, Bson filter, Bson update) {
        return Collection.exec(collection, c -> c.updateMany(session, filter, update));
    }

    public static <D> CompletionStage<UpdateResult> updateMany(MongoCollection<D> collection, Bson filter, Bson update, UpdateOptions options) {
        return Collection.exec(collection, c -> c.updateMany(filter, update, options));
    }

    public static <D> CompletionStage<UpdateResult> updateMany(MongoCollection<D> collection, ClientSession session, Bson filter, Bson update, UpdateOptions options) {
        return Collection.exec(collection, c -> c.updateMany(session, filter, update, options));
    }

    public static <D> CompletionStage<UpdateResult> updateOne(MongoCollection<D> collection, Bson filter, Bson update) {
        return Collection.exec(collection, c -> c.updateOne(filter, update));
    }

    public static <D> CompletionStage<UpdateResult> updateOne(MongoCollection<D> collection, ClientSession session, Bson filter, Bson update) {
        return Collection.exec(collection, c -> c.updateOne(session, filter, update));
    }

    public static <D> CompletionStage<UpdateResult> updateOne(MongoCollection<D> collection, Bson filter, Bson update, UpdateOptions options) {
        return Collection.exec(collection, c -> c.updateOne(filter, update, options));
    }

    public static <D> CompletionStage<UpdateResult> updateOne(MongoCollection<D> collection, ClientSession session, Bson filter, Bson update, UpdateOptions options) {
        return Collection.exec(collection, c -> c.updateOne(session, filter, update, options));
    }

    public static <D> CompletionStage<UpdateResult> updateOne(MongoCollection<D> collection, Bson filter, List<? extends Bson> update) {
        return Collection.exec(collection, c -> c.updateOne(filter, update));
    }

    public static <D> CompletionStage<UpdateResult> updateOne(MongoCollection<D> collection, ClientSession session, Bson filter, List<? extends Bson> update) {
        return Collection.exec(collection, c -> c.updateOne(session, filter, update));
    }

    public static <D> CompletionStage<UpdateResult> updateOne(MongoCollection<D> collection, Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return Collection.exec(collection, c -> c.updateOne(filter, update, options));
    }

    public static <D> CompletionStage<UpdateResult> updateOne(MongoCollection<D> collection, ClientSession session, Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return Collection.exec(collection, c -> c.updateOne(session, filter, update, options));
    }
}

