/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;
import net.pincette.util.Collections;
import net.pincette.util.Pair;

class Conditional {
    private static final String BRANCHES = "branches";
    private static final String CASE = "case";
    private static final String DEFAULT = "default";
    private static final String ELSE = "else";
    private static final String IF = "if";
    private static final String THEN = "then";

    private Conditional() {
    }

    private static List<Pair<Implementation, Implementation>> branches(JsonValue value, Features features) {
        return Optional.of(value).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).map(array -> array.stream().filter(JsonUtil::isObject).map(JsonValue::asJsonObject).filter(json -> json.containsKey(CASE) && json.containsKey(THEN)).map(json -> Pair.pair(Expression.implementation(json.getValue("/case"), features), Expression.implementation(json.getValue("/then"), features))).collect(Collectors.toList())).orElse(null);
    }

    static Implementation cond(JsonValue value, Features features) {
        List<Implementation> implementations = JsonUtil.isArray(value) ? Expression.implementations(value, features) : Collections.list(Expression.memberFunction(value, IF, features), Expression.memberFunction(value, THEN, features), Expression.memberFunction(value, ELSE, features));
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars, fncs -> fncs.stream().allMatch(Objects::nonNull)).map(values -> (JsonValue)values.get(Expression.isFalse((JsonValue)values.get(0)) ? 2 : 1)).orElse(JsonValue.NULL);
    }

    static Implementation ifNull(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementationsNum(implementations, json, vars, 2).map(values -> (JsonValue)values.get(((JsonValue)values.get(0)).equals(JsonValue.NULL) ? 1 : 0)).orElse(JsonValue.NULL);
    }

    static Implementation switchFunction(JsonValue value, Features features) {
        List branches = Expression.member(value, BRANCHES, expr -> Conditional.branches(expr, features)).orElse(null);
        Implementation defaultFunction = Expression.memberFunction(value, DEFAULT, features);
        return (json, vars) -> branches != null && defaultFunction != null ? branches.stream().map(pair -> Pair.pair((JsonValue)((Implementation)pair.first).apply(json, vars), (Implementation)pair.second)).filter(pair -> !Expression.isFalse((JsonValue)pair.first)).map(pair -> (JsonValue)((Implementation)pair.second).apply(json, vars)).findFirst().orElseGet(() -> (JsonValue)defaultFunction.apply(json, vars)) : JsonValue.NULL;
    }
}

