/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import net.pincette.json.Jslt;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Arithmetic;
import net.pincette.mongo.Arrays;
import net.pincette.mongo.Booleans;
import net.pincette.mongo.BsonUtil;
import net.pincette.mongo.Cmp;
import net.pincette.mongo.Conditional;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;
import net.pincette.mongo.Operator;
import net.pincette.mongo.Relational;
import net.pincette.mongo.Sets;
import net.pincette.mongo.Strings;
import net.pincette.mongo.Trigonometry;
import net.pincette.mongo.Types;
import net.pincette.mongo.Util;
import net.pincette.mongo.Zip;
import net.pincette.util.Collections;
import net.pincette.util.Or;
import net.pincette.util.Pair;
import org.bson.conversions.Bson;

public class Expression {
    private static final String ABS = "$abs";
    private static final String ADD = "$add";
    private static final String ALL_ELEMENTS_TRUE = "$allElementsTrue";
    private static final String AND = "$and";
    private static final String ANY_ELEMENTS_TRUE = "$anyElementsTrue";
    private static final String ARRAY_ELEM_AT = "$arrayElemAt";
    private static final String ARRAY_TO_OBJECT = "$arrayToObject";
    private static final String ACOS = "$acos";
    private static final String ACOSH = "$acosh";
    private static final String ASIN = "$asin";
    private static final String ASINH = "$asinh";
    private static final String ATAN = "$atan";
    private static final String ATANH = "$atanh";
    private static final String ATAN2 = "$atan2";
    private static final String CEIL = "$ceil";
    private static final String CMP = "$cmp";
    private static final String CONCAT = "$concat";
    private static final String CONCAT_ARRAYS = "$concatArrays";
    private static final String COND = "$cond";
    private static final String CONVERT = "$convert";
    private static final String COS = "$cos";
    private static final String DEGREES_TO_RADIANS = "$degreesToRadians";
    private static final String DIVIDE = "$divide";
    private static final String ELEM_MATCH = "$elemMatch";
    private static final String EQ = "$eq";
    private static final String EXP = "$exp";
    private static final String FILTER = "$filter";
    private static final String FIRST = "$first";
    private static final String FLOOR = "$floor";
    private static final String GT = "$gt";
    private static final String GTE = "$gte";
    private static final String IF_NULL = "$ifNull";
    private static final String IN = "$in";
    private static final String IN_FIELD = "in";
    private static final String INDEX_OF_ARRAY = "$indexOfArray";
    private static final String INDEX_OF_CP = "$indexOfCP";
    private static final String INPUT = "input";
    private static final String IS_ARRAY = "$isArray";
    private static final String JSLT = "$jslt";
    private static final String LAST = "$last";
    private static final String LET = "$let";
    private static final String LITERAL = "$literal";
    private static final String LN = "$ln";
    private static final String LOG = "$log";
    private static final String LOG_10 = "$log10";
    private static final String LT = "$lt";
    private static final String LTE = "$lte";
    private static final String LTRIM = "$ltrim";
    private static final String MAP = "$map";
    private static final String MERGE_OBJECTS = "$mergeObjects";
    private static final String MOD = "$mod";
    private static final String MULTIPLY = "$multiply";
    private static final String NE = "$ne";
    private static final String NOT = "$not";
    private static final String NOW = "$$NOW";
    private static final String OBJECT_TO_ARRAY = "$objectToArray";
    private static final String OR = "$or";
    private static final String SORT = "$sort";
    private static final String POW = "$pow";
    private static final String RADIANS_TO_DEGREES = "$radiansToDegrees";
    private static final String RANGE = "$range";
    private static final String REDUCE = "$reduce";
    private static final String REGEX_FIND = "$regexFind";
    private static final String REGEX_FIND_ALL = "$regexFindAll";
    private static final String REGEX_MATCH = "$regexMatch";
    private static final String REVERSE_ARRAY = "$reverseArray";
    private static final String ROOT = "$$ROOT";
    private static final String ROUND = "$round";
    private static final String RTRIM = "$rtrim";
    private static final String SCRIPT = "script";
    private static final String SET_DIFFERENCE = "$setDifference";
    private static final String SET_EQUALS = "$setEquals";
    private static final String SET_INTERSECTION = "$setIntersection";
    private static final String SET_IS_SUBSET = "$setIsSubset";
    private static final String SET_UNION = "$setUnion";
    private static final String SIN = "$sin";
    private static final String SIZE = "$size";
    private static final String SLICE = "$slice";
    private static final String SPLIT = "$split";
    private static final String SQRT = "$sqrt";
    private static final String STR_LEN_CP = "$strLenCP";
    private static final String STRCASECMP = "$strcasecmp";
    private static final String SUBSTR_CP = "$substrCP";
    private static final String SUBTRACT = "$subtract";
    private static final String SWITCH = "$switch";
    private static final String TAN = "$tan";
    private static final String TO_BOOL = "$toBool";
    private static final String TO_DECIMAL = "$toDecimal";
    private static final String TO_DOUBLE = "$toDouble";
    private static final String TO_INT = "$toInt";
    private static final String TO_LONG = "$toLong";
    private static final String TO_LOWER = "$toLower";
    private static final String TO_STRING = "$toString";
    private static final String TO_UPPER = "$toUpper";
    private static final String TODAY = "$$TODAY";
    private static final String TRIM = "$trim";
    private static final String TRUNC = "$trunc";
    private static final String TYPE = "$type";
    private static final String UNESCAPE = "$unescape";
    private static final String VARS = "vars";
    private static final String ZIP = "$zip";
    private static final Map<String, Operator> ARITHMETIC = Collections.map(Pair.pair("$abs", Arithmetic::abs), Pair.pair("$add", Arithmetic::add), Pair.pair("$ceil", Arithmetic::ceil), Pair.pair("$divide", Arithmetic::divide), Pair.pair("$exp", Arithmetic::exp), Pair.pair("$floor", Arithmetic::floor), Pair.pair("$ln", Arithmetic::ln), Pair.pair("$log", Arithmetic::log), Pair.pair("$log10", Arithmetic::log10), Pair.pair("$mod", Arithmetic::mod), Pair.pair("$multiply", Arithmetic::multiply), Pair.pair("$pow", Arithmetic::pow), Pair.pair("$round", Arithmetic::round), Pair.pair("$sqrt", Arithmetic::sqrt), Pair.pair("$subtract", Arithmetic::subtract), Pair.pair("$trunc", Arithmetic::trunc));
    private static final Map<String, Operator> ARRAYS = Collections.map(Pair.pair("$arrayElemAt", Arrays::arrayElemAt), Pair.pair("$arrayToObject", Arrays::arrayToObject), Pair.pair("$concatArrays", Arrays::concatArrays), Pair.pair("$elemMatch", Arrays::elemMatch), Pair.pair("$filter", Arrays::filter), Pair.pair("$first", Arrays::first), Pair.pair("$in", Arrays::in), Pair.pair("$indexOfArray", Arrays::indexOfArray), Pair.pair("$isArray", Arrays::isArray), Pair.pair("$last", Arrays::last), Pair.pair("$map", Arrays::mapOp), Pair.pair("$objectToArray", Arrays::objectToArray), Pair.pair("$range", Arrays::range), Pair.pair("$reduce", Arrays::reduce), Pair.pair("$reverseArray", Arrays::reverseArray), Pair.pair("$size", Arrays::size), Pair.pair("$slice", Arrays::slice), Pair.pair("$sort", Arrays::sort));
    private static final Map<String, Operator> BOOLEANS = Collections.map(Pair.pair("$and", Booleans::and), Pair.pair("$not", Booleans::not), Pair.pair("$or", Booleans::or));
    private static final Map<String, Operator> CONDITIONAL = Collections.map(Pair.pair("$cond", Conditional::cond), Pair.pair("$ifNull", Conditional::ifNull), Pair.pair("$switch", Conditional::switchFunction));
    private static final Map<String, Operator> RELATIONAL = Collections.map(Pair.pair("$eq", Relational.asFunction(Relational::eq)), Pair.pair("$gt", Relational.asFunction(Relational::gt)), Pair.pair("$gte", Relational.asFunction(Relational::gte)), Pair.pair("$lt", Relational.asFunction(Relational::lt)), Pair.pair("$lte", Relational.asFunction(Relational::lte)), Pair.pair("$ne", Relational.asFunction(Relational::ne)));
    private static final Map<String, Operator> SETS = Collections.map(Pair.pair("$allElementsTrue", Sets::allElementsTrue), Pair.pair("$anyElementsTrue", Sets::anyElementsTrue), Pair.pair("$setDifference", Sets::setDifference), Pair.pair("$setEquals", Sets::setEquals), Pair.pair("$setIntersection", Sets::setIntersection), Pair.pair("$setIsSubset", Sets::setIsSubset), Pair.pair("$setUnion", Sets::setUnion));
    private static final Map<String, Operator> STRINGS = Collections.map(Pair.pair("$concat", Strings::concat), Pair.pair("$indexOfCP", Strings::indexOfCP), Pair.pair("$ltrim", Strings::ltrim), Pair.pair("$regexFind", Strings::regexFind), Pair.pair("$regexFindAll", Strings::regexFindAll), Pair.pair("$regexMatch", Strings::regexMatch), Pair.pair("$rtrim", Strings::rtrim), Pair.pair("$split", Strings::split), Pair.pair("$strLenCP", Strings::strLenCP), Pair.pair("$strcasecmp", Strings::strcasecmp), Pair.pair("$substrCP", Strings::substrCP), Pair.pair("$toLower", Strings::toLower), Pair.pair("$toUpper", Strings::toUpper), Pair.pair("$trim", Strings::trim));
    private static final Map<String, Operator> TRIGONOMETRY = Collections.map(Pair.pair("$acos", Trigonometry::acos), Pair.pair("$acosh", Trigonometry::acosh), Pair.pair("$asin", Trigonometry::asin), Pair.pair("$asinh", Trigonometry::asinh), Pair.pair("$atan", Trigonometry::atan), Pair.pair("$atanh", Trigonometry::atanh), Pair.pair("$atan2", Trigonometry::atan2), Pair.pair("$cos", Trigonometry::cos), Pair.pair("$degreesToRadians", Trigonometry::degreesToRadians), Pair.pair("$radiansToDegrees", Trigonometry::radiansToDegrees), Pair.pair("$sin", Trigonometry::sin), Pair.pair("$tan", Trigonometry::tan));
    private static final Map<String, Operator> TYPES = Collections.map(Pair.pair("$convert", Types::convert), Pair.pair("$toBool", Types::toBool), Pair.pair("$toDecimal", Types::toDecimal), Pair.pair("$toDouble", Types::toDouble), Pair.pair("$toInt", Types::toInt), Pair.pair("$toLong", Types::toLong), Pair.pair("$toString", Types::toString), Pair.pair("$type", Types::type));
    private static final Map<String, Operator> OPERATORS = Collections.merge(ARITHMETIC, ARRAYS, BOOLEANS, CONDITIONAL, RELATIONAL, SETS, STRINGS, TRIGONOMETRY, TYPES, Collections.map(Pair.pair("$cmp", Cmp::cmp), Pair.pair("$jslt", Expression::jslt), Pair.pair("$let", Expression::let), Pair.pair("$literal", (v, f) -> Expression.literal(v)), Pair.pair("$mergeObjects", Expression::mergeObjects), Pair.pair("$unescape", Expression::unescape), Pair.pair("$zip", Zip::zip)));

    private Expression() {
    }

    static Optional<List<JsonValue>> applyImplementations(List<Implementation> implementations, JsonObject json, Map<String, JsonValue> variables) {
        return Expression.applyImplementations(implementations, json, variables, fncs -> true);
    }

    static Optional<List<JsonValue>> applyImplementations(List<Implementation> implementations, JsonObject json, Map<String, JsonValue> variables, Predicate<List<Implementation>> condition) {
        return Optional.ofNullable(implementations).filter(condition).map(fncs -> fncs.stream().map(f -> f == null ? null : (JsonValue)f.apply(json, variables)).collect(Collectors.toList()));
    }

    static Optional<List<JsonValue>> applyImplementationsNum(List<Implementation> functions, JsonObject json, Map<String, JsonValue> variables, int num) {
        return Expression.applyImplementations(functions, json, variables, fncs -> fncs.size() == num);
    }

    private static Map<String, JsonValue> applyVariables(JsonObject json, Map<String, JsonValue> variables, Map<String, Implementation> implementations) {
        return Collections.merge(variables, implementations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (JsonValue)((Implementation)e.getValue()).apply(json, variables))));
    }

    static Implementation arraysOperator(JsonValue value, Function<List<JsonArray>, JsonValue> op, Features features) {
        return Expression.multipleOperator(value, op, JsonUtil::isArray, JsonValue::asJsonArray, features);
    }

    static Implementation arraysOperatorTwo(JsonValue value, BiFunction<JsonArray, JsonArray, JsonValue> op, Features features) {
        return Expression.multipleOperator(value, arrays -> arrays.size() == 2 ? (JsonValue)op.apply((JsonArray)arrays.get(0), (JsonArray)arrays.get(1)) : null, JsonUtil::isArray, JsonValue::asJsonArray, features);
    }

    static Implementation bigMath(JsonValue value, UnaryOperator<BigDecimal> op, Features features) {
        return Expression.math(value, JsonNumber::bigDecimalValue, op, features);
    }

    static Implementation bigMathTwo(JsonValue value, BinaryOperator<BigDecimal> op, boolean optional, Features features) {
        return Expression.mathTwo(value, JsonNumber::bigDecimalValue, op, optional, features);
    }

    public static Function<JsonObject, JsonValue> function(JsonValue expression) {
        return Expression.function(expression, null, null);
    }

    public static Function<JsonObject, JsonValue> function(JsonValue expression, Features features) {
        return Expression.function(expression, null, features);
    }

    public static Function<JsonObject, JsonValue> function(JsonValue expression, Map<String, JsonValue> variables) {
        return Expression.function(expression, variables, null);
    }

    public static Function<JsonObject, JsonValue> function(JsonValue expression, Map<String, JsonValue> variables, Features features) {
        Implementation implementation = Expression.implementation(expression, features);
        Map<String, JsonValue> vars = Expression.stripDollars(variables != null ? variables : java.util.Collections.emptyMap());
        return json -> (JsonValue)implementation.apply(json, vars);
    }

    public static Function<JsonObject, JsonValue> function(Bson expression) {
        return Expression.function(expression, null, null);
    }

    public static Function<JsonObject, JsonValue> function(Bson expression, Features features) {
        return Expression.function(expression, null, features);
    }

    public static Function<JsonObject, JsonValue> function(Bson expression, Map<String, JsonValue> variables) {
        return Expression.function(expression, variables, null);
    }

    public static Function<JsonObject, JsonValue> function(Bson expression, Map<String, JsonValue> variables, Features features) {
        return Expression.function(BsonUtil.fromBson(BsonUtil.toBsonDocument(expression)), variables, features);
    }

    static int getInteger(List<JsonValue> values, int index) {
        return JsonUtil.asInt(values.get(index));
    }

    static String getString(List<JsonValue> values, int index) {
        return JsonUtil.asString(values.get(index)).getString();
    }

    private static Optional<JsonValue> getVariable(Map<String, JsonValue> variables, String name) {
        return Optional.ofNullable(variables.get(Optional.of(name.indexOf(46)).filter(i -> i != -1).map(i -> name.substring(0, (int)i)).orElse(name)));
    }

    private static Optional<Implementation> implementation(String key, JsonValue expression, Features features) {
        return Or.tryWith(() -> OPERATORS.get(key)).or(() -> Optional.ofNullable(features).map(f -> f.expressionExtensions).map(e -> (Operator)e.get(key)).orElse(null)).get().map(fn -> (Implementation)fn.apply(expression, features));
    }

    public static Implementation implementation(JsonValue expression, Features features) {
        Pair<JsonValue, Boolean> unwrapped = Util.unwrapTrace(expression);
        Supplier<Implementation> tryArray = () -> JsonUtil.isArray((JsonValue)unwrapped.first) ? Expression.implementation(((JsonValue)unwrapped.first).asJsonArray(), features) : Expression.value((JsonValue)unwrapped.first);
        return Expression.wrapLogging(JsonUtil.isObject((JsonValue)unwrapped.first) ? Expression.implementation(((JsonValue)unwrapped.first).asJsonObject(), features) : tryArray.get(), (JsonValue)unwrapped.first, Boolean.TRUE.equals(unwrapped.second) ? Level.INFO : Level.FINEST);
    }

    private static Implementation implementation(JsonObject expression, Features features) {
        return Util.key(expression).flatMap(key -> Expression.implementation(key, expression.getValue("/" + key), features)).orElseGet(() -> Expression.recursiveImplementation(expression, features));
    }

    private static Implementation implementation(JsonArray expression, Features features) {
        List implementations = expression.stream().map(expr -> Expression.implementation(expr, features)).collect(Collectors.toList());
        return (json, vars) -> implementations.stream().reduce(JsonUtil.createArrayBuilder(), (b, i) -> b.add((JsonValue)i.apply(json, vars)), (b1, b2) -> b1).build();
    }

    static List<Implementation> implementations(JsonValue expression, Features features) {
        return JsonUtil.isArray(expression) ? expression.asJsonArray().stream().map(expr -> Expression.implementation(expr, features)).collect(Collectors.toList()) : null;
    }

    static boolean isFalse(JsonValue value) {
        return value.equals(JsonValue.FALSE) || value.equals(JsonValue.NULL) || JsonUtil.isNumber(value) && JsonUtil.asNumber(value).intValue() == 0;
    }

    static boolean isScalar(JsonValue value) {
        return !(value instanceof JsonStructure);
    }

    private static Implementation jslt(JsonValue value, Features features) {
        Implementation input = Expression.jsltInput(value, features);
        UnaryOperator<JsonValue> script = Expression.jsltScript(value, features);
        return (json, vars) -> input != null && script != null ? Optional.of((JsonValue)input.apply(json, vars)).filter(JsonUtil::isObject).map(JsonValue::asJsonObject).map(script).map(JsonUtil::createValue).orElse(JsonValue.NULL) : JsonValue.NULL;
    }

    private static Implementation jsltInput(JsonValue value, Features features) {
        return Or.tryWith(() -> Expression.memberFunction(value, INPUT, features)).or(() -> Expression.implementation(JsonUtil.createValue(ROOT), features)).get().orElse(null);
    }

    private static UnaryOperator<JsonValue> jsltScript(JsonValue value, Features features) {
        return Or.tryWith(() -> Expression.member(value, SCRIPT, v -> JsonUtil.stringValue(v).orElse(null)).orElse(null)).or(() -> JsonUtil.stringValue(value).orElse(null)).get().map(s -> Jslt.transformerValue(new Jslt.Context(Jslt.tryReader(s)).withResolver(features != null ? features.jsltResolver : null).withFunctions(features != null ? features.customJsltFunctions : null))).orElse(null);
    }

    private static Implementation let(JsonValue value, Features features) {
        Implementation in = Expression.memberFunction(value, IN_FIELD, features);
        Map<String, Implementation> variables = Expression.variables(value, features);
        return (json, vars) -> Optional.ofNullable(in).map(i -> (JsonValue)i.apply(json, Expression.applyVariables(json, vars, variables))).orElse(JsonValue.NULL);
    }

    private static Implementation literal(JsonValue value) {
        return (json, vars) -> value;
    }

    private static JsonValue log(JsonValue expression, JsonObject json, Map<String, JsonValue> variables, JsonValue result, Level level) {
        Util.logger.log(level, () -> "Expression:\n" + JsonUtil.string(expression) + "\n\nWith:\n" + JsonUtil.string(json) + "\n\nVariables:\n" + Expression.variables(variables) + "\n\nYields: " + JsonUtil.string(result) + "\n\n");
        return result;
    }

    public static Logger logger() {
        return Util.logger;
    }

    static Implementation math(JsonValue value, UnaryOperator<Double> op, Features features) {
        return Expression.math(value, JsonNumber::doubleValue, op, features);
    }

    private static <T> Implementation math(JsonValue value, Function<JsonNumber, T> toValue, UnaryOperator<T> op, Features features) {
        Implementation implementation = Expression.implementation(value, features);
        return (json, vars) -> Expression.numeric(implementation, json, vars).map(toValue).map(op).map(JsonUtil::createValue).orElse(JsonValue.NULL);
    }

    static Implementation mathTwo(JsonValue value, BinaryOperator<Double> op, boolean optional, Features features) {
        return Expression.mathTwo(value, JsonNumber::doubleValue, op, optional, features);
    }

    private static <T> Implementation mathTwo(JsonValue value, Function<JsonNumber, T> toValue, BinaryOperator<T> op, boolean optional, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars, fncs -> fncs.size() == 1 && optional || fncs.size() == 2).filter(values -> values.stream().allMatch(JsonUtil::isNumber)).map(values -> op.apply(toValue.apply(JsonUtil.asNumber((JsonValue)values.get(0))), values.size() == 2 ? (Object)toValue.apply(JsonUtil.asNumber((JsonValue)values.get(1))) : null)).map(JsonUtil::createValue).orElse(JsonValue.NULL);
    }

    static <T> Optional<T> member(JsonValue value, String name, Function<JsonValue, T> extract) {
        return Optional.of(value).filter(JsonUtil::isObject).map(JsonValue::asJsonObject).flatMap(o -> JsonUtil.getValue(o, "/" + name)).map(extract);
    }

    public static Implementation memberFunction(JsonValue expression, String name, Features features) {
        return Expression.member(expression, name, expr -> Expression.implementation(expr, features)).orElse(null);
    }

    public static List<Implementation> memberFunctions(JsonValue expression, String name, Features features) {
        return Expression.member(expression, name, expr -> Expression.implementations(expr, features)).orElse(null);
    }

    private static Implementation mergeObjects(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars).filter(values -> values.stream().allMatch(JsonUtil::isObject)).map(Expression::mergeObjects).orElse(JsonValue.NULL);
    }

    private static JsonValue mergeObjects(List<JsonValue> values) {
        return values.stream().map(JsonValue::asJsonObject).reduce(JsonUtil.createObjectBuilder(), (b, o) -> JsonUtil.copy(o, b, (k, ob) -> !((JsonValue)ob.get(k)).equals(JsonValue.NULL)), (b1, b2) -> b1).build();
    }

    private static <T> Implementation multipleOperator(JsonValue value, Function<List<T>, JsonValue> op, Predicate<JsonValue> predicate, Function<JsonValue, T> map, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars).map(values -> values.stream().filter(predicate).map(map).collect(Collectors.toList())).filter(list -> list.size() == implementations.size()).map(op).orElse(JsonValue.NULL);
    }

    private static Optional<JsonNumber> numeric(Implementation implementation, JsonObject json, Map<String, JsonValue> variables) {
        return Optional.ofNullable(implementation).map(f -> (JsonValue)f.apply(json, variables)).filter(JsonUtil::isNumber).map(JsonUtil::asNumber);
    }

    private static Implementation recursiveImplementation(JsonObject expression, Features features) {
        Map<String, Implementation> implementations = expression.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Expression.implementation((JsonValue)e.getValue(), features)));
        return (json, vars) -> implementations.entrySet().stream().reduce(JsonUtil.createObjectBuilder(), (b, e) -> b.add((String)e.getKey(), (JsonValue)((Implementation)e.getValue()).apply(json, vars)), (b1, b2) -> b1).build();
    }

    public static JsonValue replaceVariables(JsonValue expression, Map<String, JsonValue> variables) {
        switch (expression.getValueType()) {
            case ARRAY: {
                return Expression.replaceVariables(expression.asJsonArray(), variables);
            }
            case OBJECT: {
                return Expression.replaceVariables(expression.asJsonObject(), variables);
            }
            case STRING: {
                return Expression.replaceVariables(JsonUtil.asString(expression), variables);
            }
        }
        return expression;
    }

    private static JsonValue replaceVariables(JsonString expression, Map<String, JsonValue> variables) {
        return Optional.of(expression.getString()).flatMap(expr -> Expression.getVariable(variables, expr).map(value -> Pair.pair(expr, value))).map(pair -> Expression.value((JsonValue)pair.second, ((String)pair.first).substring(2))).orElse(expression);
    }

    private static JsonValue replaceVariables(JsonArray expressions, Map<String, JsonValue> variables) {
        return Util.toArray(expressions.stream().map(v -> Expression.replaceVariables(v, variables)));
    }

    private static JsonValue replaceVariables(JsonObject expressions, Map<String, JsonValue> variables) {
        return expressions.entrySet().stream().reduce(JsonUtil.createObjectBuilder(), (b, e) -> b.add((String)e.getKey(), Expression.replaceVariables((JsonValue)e.getValue(), variables)), (b1, b2) -> b1).build();
    }

    static Implementation stringsOperator(JsonValue value, Function<List<String>, JsonValue> op, Features features) {
        return Expression.multipleOperator(value, op, JsonUtil::isString, v -> JsonUtil.asString(v).getString(), features);
    }

    private static Map<String, JsonValue> stripDollars(Map<String, JsonValue> variables) {
        return variables.entrySet().stream().collect(Collectors.toMap(e -> Expression.stripDollars((String)e.getKey()), Map.Entry::getValue));
    }

    private static String stripDollars(String name) {
        return name.startsWith("$$") ? name.substring(2) : name;
    }

    private static Implementation unescape(JsonValue value, Features features) {
        Implementation implementation = Expression.implementation(value, features);
        return (json, vars) -> Expression.unescapeKeys((JsonValue)implementation.apply(json, vars));
    }

    private static String unescapeKey(String key) {
        return key.startsWith("#$") ? key.substring(1) : key;
    }

    private static JsonValue unescapeKeys(JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                return Expression.unescapeKeys(value.asJsonArray());
            }
            case OBJECT: {
                return Expression.unescapeKeys(value.asJsonObject());
            }
        }
        return value;
    }

    private static JsonValue unescapeKeys(JsonArray array) {
        return Util.toArray(array.stream().map(Expression::unescapeKeys));
    }

    private static JsonValue unescapeKeys(JsonObject object) {
        return object.entrySet().stream().reduce(JsonUtil.createObjectBuilder(), (b, e) -> b.add(Expression.unescapeKey((String)e.getKey()), Expression.unescapeKeys((JsonValue)e.getValue())), (b1, b2) -> b1).build();
    }

    private static Implementation value(JsonValue value) {
        return (json, variables) -> JsonUtil.stringValue(value).flatMap(s -> Expression.value(json, s, variables)).orElse(value);
    }

    private static Optional<JsonValue> value(JsonObject json, String value, Map<String, JsonValue> variables) {
        return Or.tryWith(() -> value.equals(NOW) ? JsonUtil.createValue(Instant.now().toString()) : null).or(() -> value.equals(TODAY) ? JsonUtil.createValue(LocalDate.now().toString()) : null).or(() -> value.equals(ROOT) ? json : null).or(() -> value.startsWith("$$") ? Expression.value(variables, value.substring(2)) : null).or(() -> value.startsWith("$") ? JsonUtil.getValue(json, JsonUtil.toJsonPointer(value.substring(1))).orElse(JsonValue.NULL) : null).get();
    }

    private static JsonValue value(Map<String, JsonValue> variables, String variable) {
        Pair<String, String> name = Expression.variableName(variable);
        return Expression.value(variables.get(name.first), name);
    }

    static JsonValue value(JsonValue value, String variable) {
        return Expression.value(value, Expression.variableName(variable));
    }

    private static JsonValue value(JsonValue value, Pair<String, String> variable) {
        return Optional.ofNullable(value).filter(v -> variable.second == null || JsonUtil.isObject(v)).map(v -> variable.second != null ? JsonUtil.getValue(v.asJsonObject(), JsonUtil.toJsonPointer((String)variable.second)).orElse(JsonValue.NULL) : value).orElse(JsonValue.NULL);
    }

    private static Pair<String, String> variableName(String variable) {
        return Optional.of(variable.indexOf(46)).filter(i -> i != -1).map(i -> Pair.pair(variable.substring(0, (int)i), variable.substring(i + 1))).orElseGet(() -> Pair.pair(variable, null));
    }

    private static Map<String, Implementation> variables(JsonValue value, Features features) {
        return Optional.of(value).filter(JsonUtil::isObject).map(JsonValue::asJsonObject).map(json -> json.getJsonObject(VARS)).map(Map::entrySet).map(Collection::stream).map(stream -> stream.collect(Collectors.toMap(Map.Entry::getKey, e -> Expression.implementation((JsonValue)e.getValue(), features)))).orElseGet(java.util.Collections::emptyMap);
    }

    private static String variables(Map<String, JsonValue> variables) {
        return variables.entrySet().stream().map(e -> (String)e.getKey() + ": " + JsonUtil.string((JsonValue)e.getValue())).collect(Collectors.joining("\n"));
    }

    private static Implementation wrapLogging(Implementation implementation, JsonValue expression, Level level) {
        return (json, vars) -> Optional.of((JsonValue)implementation.apply(json, vars)).map(result -> Expression.log(expression, json, vars, result, level)).orElse(null);
    }
}

