/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.BsonUtil;
import net.pincette.mongo.Cmp;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.QueryOperator;
import net.pincette.mongo.Relational;
import net.pincette.mongo.Util;
import net.pincette.util.Or;
import net.pincette.util.Pair;
import org.bson.conversions.Bson;

public class Match {
    private static final String ALL = "$all";
    private static final String AND = "$and";
    private static final String ARRAY = "array";
    private static final String BITS_ALL_CLEAR = "$bitsAllClear";
    private static final String BITS_ALL_SET = "$bitsAllSet";
    private static final String BITS_ANY_CLEAR = "$bitsAnyClear";
    private static final String BITS_ANY_SET = "$bitsAnySet";
    private static final String BOOL = "bool";
    private static final String DATE = "date";
    private static final String DECIMAL = "decimal";
    private static final String DOUBLE = "double";
    private static final String ELEM_MATCH = "$elemMatch";
    private static final String EQ = "$eq";
    private static final String EXISTS = "$exists";
    private static final String EXPR = "$expr";
    private static final String GT = "$gt";
    private static final String GTE = "$gte";
    private static final String IN = "$in";
    private static final String INT = "int";
    private static final String LONG = "long";
    private static final String LT = "$lt";
    private static final String LTE = "$lte";
    private static final String MOD = "$mod";
    private static final String NE = "$ne";
    private static final String NIN = "$nin";
    private static final String NOR = "$nor";
    private static final String NOT = "$not";
    private static final String NULL_TYPE = "null";
    private static final String OBJECT = "object";
    private static final String OPTIONS = "$options";
    private static final String OR = "$or";
    private static final String REGEX = "$regex";
    private static final String SIZE = "$size";
    private static final String STRING = "string";
    private static final String TIMESTAMP = "timestamp";
    private static final String TYPE = "$type";
    private static final Set<String> COMBINERS = net.pincette.util.Collections.set("$and", "$expr", "$nor", "$or");
    private static final Set<String> SUPPORTED_TYPES = net.pincette.util.Collections.set("array", "bool", "date", "decimal", "double", "int", "long", "null", "object", "string", "timestamp");
    private static final Map<String, QueryOperator> QUERY_OPERATORS = net.pincette.util.Collections.map(Pair.pair("$all", (e, f) -> Match.all(e)), Pair.pair("$bitsAllClear", (e, f) -> Match.bitsAllClear(e)), Pair.pair("$bitsAllSet", (e, f) -> Match.bitsAllSet(e)), Pair.pair("$bitsAnyClear", (e, f) -> Match.bitsAnyClear(e)), Pair.pair("$bitsAnySet", (e, f) -> Match.bitsAnySet(e)), Pair.pair("$elemMatch", Match::elemMatch), Pair.pair("$eq", (e, f) -> Match.eq(e)), Pair.pair("$exists", (e, f) -> Match.exists(e)), Pair.pair("$gt", (e, f) -> Match.gt(e)), Pair.pair("$gte", (e, f) -> Match.gte(e)), Pair.pair("$in", (e, f) -> Match.in(e)), Pair.pair("$lt", (e, f) -> Match.lt(e)), Pair.pair("$lte", (e, f) -> Match.lte(e)), Pair.pair("$mod", (e, f) -> Match.mod(e)), Pair.pair("$ne", (e, f) -> Match.ne(e)), Pair.pair("$nin", (e, f) -> Match.nin(e)), Pair.pair("$not", Match::not), Pair.pair("$size", (e, f) -> Match.size(e)), Pair.pair("$type", (e, f) -> Match.type(e)));

    private Match() {
    }

    private static Predicate<JsonObject> aggregationExpression(JsonValue value, Features features) {
        Function<JsonObject, JsonValue> function = Expression.function(value, features);
        return json -> !Expression.isFalse((JsonValue)function.apply((JsonObject)json));
    }

    private static Predicate<JsonObject> and(JsonValue value, Features features) {
        return Match.combine(value, (p1, p2) -> json -> p1.test(json) && p2.test(json), features);
    }

    private static Predicate<JsonValue> all(JsonValue value) {
        JsonArray array = JsonUtil.isArray(value) ? JsonUtil.asArray(value) : null;
        return v -> v != null && array != null && JsonUtil.isArray(v) && Match.hasAllValues(JsonUtil.asArray(v), array);
    }

    private static Predicate<JsonValue> bits(JsonValue value, BiPredicate<Long, Long> op) {
        Optional<Long> mask = Match.mask(value);
        return v -> v != null && mask.isPresent() && JsonUtil.isNumber(v) && op.test(JsonUtil.asNumber(v).longValue(), (Long)mask.get());
    }

    private static Predicate<JsonValue> bitsAllClear(JsonValue value) {
        return Match.bits(value, (v, mask) -> (v & mask) == 0L);
    }

    private static Predicate<JsonValue> bitsAllSet(JsonValue value) {
        return Match.bits(value, (v, mask) -> (v & mask) == mask);
    }

    private static Predicate<JsonValue> bitsAnyClear(JsonValue value) {
        return Match.bits(value, (v, mask) -> (v & mask) != mask);
    }

    private static Predicate<JsonValue> bitsAnySet(JsonValue value) {
        return Match.bits(value, (v, mask) -> (v & mask) != 0L);
    }

    private static Predicate<JsonObject> booleanExpression(JsonObject expression, Features features) {
        return Util.key(expression).map(key -> Match.booleanExpression(key, expression.getValue("/" + key), features)).orElseGet(() -> Match.aggregationExpression(expression, features));
    }

    private static Predicate<JsonObject> booleanExpression(String key, JsonValue value, Features features) {
        switch (key) {
            case "$and": {
                return Match.and(value, features);
            }
            case "$eq": {
                return Match.booleanExpression(Relational::eq, value, features);
            }
            case "$gt": {
                return Match.booleanExpression(Relational::gt, value, features);
            }
            case "$gte": {
                return Match.booleanExpression(Relational::gte, value, features);
            }
            case "$lt": {
                return Match.booleanExpression(Relational::lt, value, features);
            }
            case "$lte": {
                return Match.booleanExpression(Relational::lte, value, features);
            }
            case "$ne": {
                return Match.booleanExpression(Relational::ne, value, features);
            }
            case "$nor": {
                return Match.nor(value, features);
            }
            case "$or": {
                return Match.or(value, features);
            }
        }
        return null;
    }

    private static Predicate<JsonObject> booleanExpression(BiFunction<JsonValue, Features, Relational.RelOp> op, JsonValue value, Features features) {
        Relational.RelOp relOp = op.apply(value, features);
        Map variables = Collections.emptyMap();
        return json -> relOp.test(json, variables);
    }

    private static Predicate<JsonObject> combine(JsonValue value, BinaryOperator<Predicate<JsonObject>> combiner, Features features) {
        return JsonUtil.isArray(value) ? value.asJsonArray().stream().filter(JsonUtil::isObject).map(JsonValue::asJsonObject).map(json -> Match.predicate(json, features)).reduce(combiner).orElse(json -> false) : json -> false;
    }

    static Pattern compileRegex(String regex, String options) {
        return Pattern.compile(Match.pattern(regex), Match.flags(Match.flagsFromRegex(regex).orElse(options)));
    }

    private static Predicate<JsonValue> elemMatch(JsonValue value, Features features) {
        Predicate<JsonValue> predicate = Match.elemMatchPredicate(value, features);
        return v -> v != null && JsonUtil.isArray(v) && JsonUtil.asArray(v).stream().anyMatch(predicate);
    }

    static Predicate<JsonValue> elemMatchPredicate(JsonValue value, Features features) {
        return Optional.of(value).filter(JsonUtil::isObject).map(JsonValue::asJsonObject).map(Map::entrySet).flatMap(entries -> entries.stream().map(entry -> Match.elemMatchPredicate((String)entry.getKey(), (JsonValue)entry.getValue(), features)).reduce((p1, p2) -> v -> p1.test(v) && p2.test(v))).orElseGet(Match::falsePredicate);
    }

    private static Predicate<JsonValue> elemMatchPredicate(String key, JsonValue value, Features features) {
        return Optional.ofNullable(Match.predicate(key, value, features)).orElseGet(() -> {
            Predicate<JsonObject> predicate = Match.predicateField(key, value, features);
            return json -> JsonUtil.isObject(json) && predicate.test(json.asJsonObject());
        });
    }

    private static Predicate<JsonValue> eq(JsonValue value) {
        return value::equals;
    }

    private static Predicate<JsonValue> exists(JsonValue value) {
        Supplier<Predicate> tryTrue = () -> JsonValue.TRUE.equals(value) ? Objects::nonNull : v -> false;
        return JsonValue.FALSE.equals(value) ? Objects::isNull : tryTrue.get();
    }

    private static Predicate<JsonObject> expr(JsonValue value, Features features) {
        return JsonUtil.isObject(value) ? Match.booleanExpression(value.asJsonObject(), features) : json -> false;
    }

    private static Predicate<JsonValue> falsePredicate() {
        return v -> false;
    }

    static int flags(String options) {
        IntSupplier i = () -> options.contains("i") ? 2 : 0;
        IntSupplier m = () -> options.contains("m") ? 8 : 0;
        IntSupplier s = () -> options.contains("s") ? 32 : 0;
        IntSupplier x = () -> options.contains("x") ? 4 : 0;
        return options == null ? 0 : i.getAsInt() | m.getAsInt() | s.getAsInt() | x.getAsInt();
    }

    private static Optional<String> flagsFromRegex(String regex) {
        return Optional.of(regex.lastIndexOf(47)).filter(index -> index != -1 && index < regex.length() - 1).map(index -> regex.substring(index + 1));
    }

    private static Optional<JsonArray> getNestedArray(JsonArray array) {
        return Optional.of(array).filter(a -> a.size() == 1).map(a -> (JsonValue)a.get(0)).filter(JsonUtil::isArray).map(JsonValue::asJsonArray);
    }

    private static Pattern getRegex(JsonObject json) {
        return Optional.ofNullable(json.getString(REGEX, null)).map(regex -> Match.compileRegex(regex, json.getString(OPTIONS, null))).orElse(null);
    }

    private static Optional<Predicate<JsonValue>> getRegex(JsonValue value) {
        return Optional.of(value).filter(JsonUtil::isString).map(JsonUtil::asString).map(JsonString::getString).filter(Match::isRegexp).map(v -> Match.compileRegex(v, null)).map(pattern -> v -> Match.matches(pattern, v));
    }

    private static Predicate<JsonValue> gt(JsonValue value) {
        return v -> {
            switch (value.getValueType()) {
                case FALSE: {
                    return v != null && v.equals(JsonValue.TRUE);
                }
                case NUMBER: {
                    return v != null && JsonUtil.isNumber(v) && Cmp.compareNumbers(v, value) > 0;
                }
                case STRING: {
                    return v != null && JsonUtil.isString(v) && Cmp.compareStrings(v, value) > 0;
                }
            }
            return false;
        };
    }

    private static Predicate<JsonValue> gte(JsonValue value) {
        return v -> {
            switch (value.getValueType()) {
                case FALSE: {
                    return v != null && (v.equals(JsonValue.FALSE) || v.equals(JsonValue.TRUE));
                }
                case NUMBER: {
                    return v != null && JsonUtil.isNumber(v) && Cmp.compareNumbers(v, value) >= 0;
                }
                case STRING: {
                    return v != null && JsonUtil.isString(v) && Cmp.compareStrings(v, value) >= 0;
                }
                case TRUE: {
                    return JsonValue.TRUE.equals(v);
                }
            }
            return false;
        };
    }

    private static boolean hasAllValues(JsonArray v, JsonArray array) {
        return Match.hasAllValuesDirect(v, array) || Match.getNestedArray(array).filter(a -> Match.hasAllValuesDirect(v, a) || Match.hasAllValuesNested(v, a)).isPresent();
    }

    private static boolean hasAllValuesDirect(JsonArray v, JsonArray array) {
        return v.containsAll(array);
    }

    private static boolean hasAllValuesNested(JsonArray v, JsonArray nestedArray) {
        return v.stream().filter(JsonUtil::isArray).map(JsonValue::asJsonArray).anyMatch(a -> Match.hasAllValuesDirect(a, nestedArray));
    }

    private static Predicate<JsonValue> in(JsonValue value) {
        List values = (JsonUtil.isArray(value) ? value.asJsonArray() : Collections.emptyList()).stream().map(v -> Match.getRegex(v).orElse(v::equals)).collect(Collectors.toList());
        return v -> v != null && values.stream().anyMatch(predicate -> predicate.test(v));
    }

    private static boolean isExpression(JsonValue value) {
        return Optional.of(value).filter(JsonUtil::isObject).map(JsonValue::asJsonObject).map(Map::keySet).filter(keys -> keys.size() == 1 && ((String)keys.iterator().next()).startsWith("$") || Match.isRegexp(keys, value.asJsonObject())).isPresent();
    }

    private static boolean isRegexp(Set<String> keys, JsonObject expression) {
        return keys.size() == 2 && keys.contains(REGEX) && keys.contains(OPTIONS) && Optional.of(expression.getString(OPTIONS)).filter(options -> options.equals("") || options.matches("[imsx]+")).isPresent();
    }

    private static boolean isRegexp(String s) {
        return s.startsWith("/") && s.lastIndexOf(47) > 0;
    }

    private static boolean isType(JsonValue value, String type) {
        switch (type) {
            case "array": {
                return JsonUtil.isArray(value);
            }
            case "bool": {
                return value.equals(JsonValue.FALSE) || value.equals(JsonValue.TRUE);
            }
            case "date": {
                return JsonUtil.isDate(value);
            }
            case "int": {
                return JsonUtil.isInt(value);
            }
            case "long": {
                return JsonUtil.isLong(value);
            }
            case "double": {
                return JsonUtil.isDouble(value);
            }
            case "decimal": {
                return JsonUtil.isNumber(value);
            }
            case "null": {
                return value.equals(JsonValue.NULL);
            }
            case "object": {
                return JsonUtil.isObject(value);
            }
            case "timestamp": {
                return JsonUtil.isInstant(value);
            }
            case "string": {
                return JsonUtil.isString(value);
            }
        }
        return false;
    }

    private static boolean log(JsonObject expression, JsonObject json, boolean result, Level level) {
        Util.logger.log(level, () -> "Expression:\n" + JsonUtil.string(expression) + "\n\nWith:\n" + JsonUtil.string(json) + "\n\nYields: " + result + "\n\n");
        return result;
    }

    public static Logger logger() {
        return Util.logger;
    }

    private static Predicate<JsonValue> lt(JsonValue value) {
        return v -> {
            switch (value.getValueType()) {
                case NUMBER: {
                    return v != null && JsonUtil.isNumber(v) && Cmp.compareNumbers(v, value) < 0;
                }
                case STRING: {
                    return v != null && JsonUtil.isString(v) && Cmp.compareStrings(v, value) < 0;
                }
                case TRUE: {
                    return v != null && v.equals(JsonValue.FALSE);
                }
            }
            return false;
        };
    }

    private static Predicate<JsonValue> lte(JsonValue value) {
        return v -> {
            switch (value.getValueType()) {
                case FALSE: {
                    return JsonValue.FALSE.equals(v);
                }
                case NUMBER: {
                    return v != null && JsonUtil.isNumber(v) && Cmp.compareNumbers(v, value) <= 0;
                }
                case STRING: {
                    return v != null && JsonUtil.isString(v) && Cmp.compareStrings(v, value) <= 0;
                }
                case TRUE: {
                    return v != null && (v.equals(JsonValue.FALSE) || v.equals(JsonValue.TRUE));
                }
            }
            return false;
        };
    }

    private static Optional<Long> mask(JsonValue value) {
        return Or.tryWith(() -> Optional.of(value).filter(JsonUtil::isNumber).map(JsonUtil::asNumber).map(JsonNumber::longValue).orElse(null)).or(() -> Optional.of(value).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).map(Match::mask).orElse(null)).get();
    }

    private static long mask(JsonArray positions) {
        return positions.stream().filter(JsonUtil::isNumber).map(JsonUtil::asNumber).map(JsonNumber::longValue).filter(p -> p < 64L).reduce(0L, (r, p) -> r | (long)(1 << (int)p.longValue()), (r1, r2) -> r1);
    }

    private static boolean matches(Pattern pattern, JsonValue value) {
        return JsonUtil.isString(value) && pattern.matcher(JsonUtil.asString(value).getString()).find();
    }

    private static Predicate<JsonValue> mod(JsonValue value) {
        Function<Pair, Predicate> mod = pair -> v -> v != null && JsonUtil.isNumber(v) && JsonUtil.asNumber(v).longValue() % (Long)pair.first == (Long)pair.second;
        return Optional.of(value).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).filter(array -> array.size() == 2).filter(array -> JsonUtil.isLong((JsonValue)array.get(0)) && JsonUtil.isLong((JsonValue)array.get(1))).map(array -> Pair.pair(JsonUtil.asLong((JsonValue)array.get(0)), JsonUtil.asLong((JsonValue)array.get(1)))).map(mod).orElseGet(Match::falsePredicate);
    }

    private static Predicate<JsonValue> ne(JsonValue value) {
        return v -> !value.equals(v);
    }

    private static Predicate<JsonValue> nin(JsonValue value) {
        Predicate<JsonValue> in = Match.in(value);
        return v -> !in.test((JsonValue)v);
    }

    private static Predicate<JsonObject> nor(JsonValue value, Features features) {
        return Match.combine(value, (p1, p2) -> json -> !p1.test(json) && !p2.test(json), features);
    }

    private static Predicate<JsonValue> not(JsonValue value, Features features) {
        Predicate<JsonValue> predicate = JsonUtil.isObject(value) ? Match.predicateValue(value.asJsonObject(), features) : Match.getRegex(value).orElse(v -> true);
        return v -> !predicate.test((JsonValue)v);
    }

    private static Predicate<JsonObject> or(JsonValue value, Features features) {
        return Match.combine(value, (p1, p2) -> json -> p1.test(json) || p2.test(json), features);
    }

    private static String pattern(String regex) {
        return regex.substring(regex.startsWith("/") ? 1 : 0, Optional.of(regex.lastIndexOf(47)).filter(index -> index != -1 && regex.startsWith("/")).orElseGet(regex::length));
    }

    public static Predicate<JsonObject> predicate(JsonObject expression) {
        return Match.predicate(expression, null);
    }

    public static Predicate<JsonObject> predicate(JsonObject expression, Features features) {
        Pair<JsonObject, Boolean> unwrapped = Util.unwrapTrace(expression);
        Function<String, JsonValue> value = key -> ((JsonObject)unwrapped.first).getValue("/" + key);
        return Match.wrapLogging(Util.key((JsonObject)unwrapped.first).map(key -> COMBINERS.contains(key) ? Match.predicateCombiner(key, (JsonValue)value.apply((String)key), features) : Match.predicateField(key, (JsonValue)value.apply((String)key), features)).orElseGet(() -> Match.predicateFields((JsonObject)unwrapped.first, features)), (JsonObject)unwrapped.first, Boolean.TRUE.equals(unwrapped.second) ? Level.INFO : Level.FINEST);
    }

    public static Predicate<JsonObject> predicate(Bson expression) {
        return Match.predicate(expression, null);
    }

    public static Predicate<JsonObject> predicate(Bson expression, Features features) {
        return Match.predicate(BsonUtil.fromBson(BsonUtil.toBsonDocument(expression)), features);
    }

    private static Predicate<JsonValue> predicate(String key, JsonValue value, Features features) {
        return Or.tryWith(() -> QUERY_OPERATORS.get(key)).or(() -> Optional.ofNullable(features).map(f -> f.matchExtensions).map(e -> (QueryOperator)e.get(key)).orElse(null)).get().map(fn -> (Predicate)fn.apply(value, features)).orElse(null);
    }

    private static Predicate<JsonObject> predicateCombiner(String key, JsonValue value, Features features) {
        switch (key) {
            case "$and": {
                return Match.and(value, features);
            }
            case "$expr": {
                return Match.expr(value, features);
            }
            case "$nor": {
                return Match.nor(value, features);
            }
            case "$or": {
                return Match.or(value, features);
            }
        }
        return json -> false;
    }

    private static Predicate<JsonObject> predicateField(String field, JsonValue value, Features features) {
        Predicate<JsonValue> predicate = Match.isExpression(value) ? Match.predicateValue(value.asJsonObject(), features) : Match.eq(value);
        return json -> predicate.test(JsonUtil.getValue(json, JsonUtil.toJsonPointer(field)).orElse(null));
    }

    private static Predicate<JsonObject> predicateFields(JsonObject expression, Features features) {
        return expression.keySet().stream().filter(key -> !key.startsWith("$")).map(key -> Match.predicateField(key, expression.getValue("/" + key), features)).reduce((p1, p2) -> json -> p1.test(json) && p2.test(json)).orElseGet(() -> json -> false);
    }

    public static Predicate<JsonValue> predicateValue(JsonObject expression, Features features) {
        return Optional.of(expression.keySet()).filter(keys -> keys.size() == 1).map(keys -> (String)keys.iterator().next()).map(key -> Match.predicate(key, expression.getValue("/" + key), features)).orElseGet(() -> Match.regex(expression));
    }

    private static Predicate<JsonValue> regex(JsonObject json) {
        Pattern pattern = Match.getRegex(json);
        return v -> v != null && pattern != null && Match.matches(pattern, v);
    }

    private static Predicate<JsonValue> size(JsonValue value) {
        int size = JsonUtil.isInt(value) ? JsonUtil.asInt(value) : -1;
        return v -> v != null && size != -1 && JsonUtil.isArray(v) && v.asJsonArray().size() == size;
    }

    private static List<String> supportedTypes(JsonValue value) {
        return Optional.of(value).filter(JsonUtil::isArray).map(JsonValue::asJsonArray).map(Collection::stream).orElseGet(() -> Stream.of(value)).filter(JsonUtil::isString).map(JsonUtil::asString).map(JsonString::getString).filter(SUPPORTED_TYPES::contains).collect(Collectors.toList());
    }

    private static Predicate<JsonValue> type(JsonValue value) {
        List<String> types = Match.supportedTypes(value);
        return v -> v != null && types.stream().anyMatch(t -> Match.isType(v, t));
    }

    private static Predicate<JsonObject> wrapLogging(Predicate<JsonObject> predicate, JsonObject expression, Level level) {
        return json -> Optional.of(predicate.test((JsonObject)json)).map(result -> Match.log(expression, json, result, level)).orElse(false);
    }
}

