/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonValue;
import net.pincette.json.Factory;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.JsonClient;
import net.pincette.util.Pair;
import net.pincette.util.StreamUtil;
import net.pincette.util.Util;
import org.bson.conversions.Bson;

public class Patch {
    private static final String EACH = "$each";
    private static final String FROM = "from";
    private static final String OP = "op";
    private static final String PATH = "path";
    private static final String POSITION = "$position";
    private static final String PUSH = "$push";
    private static final String SET = "$set";
    private static final String UNSET = "$unset";
    private static final String VALUE = "value";

    private Patch() {
    }

    private static JsonObject add(JsonObject original, JsonObject op) {
        return Patch.add(original, op, (JsonValue)op.get(VALUE));
    }

    private static JsonObject add(JsonObject original, JsonObject op, JsonValue value) {
        String path = op.getString(PATH);
        return Patch.arrayValue(original, path).map(a -> Patch.setInArray(a, value)).orElseGet(() -> Patch.set(path, value));
    }

    private static Optional<ArrayValue> arrayValue(JsonObject original, String path) {
        String parent = Util.getParent(path, "/");
        return Util.getLastSegment(path, "/").filter(Util::isInteger).map(Integer::parseInt).flatMap(position -> JsonUtil.getArray(original, parent).map(a -> new ArrayValue(parent, (int)position, (JsonArray)a)));
    }

    private static JsonObject copy(JsonObject original, JsonObject op) {
        return Patch.add(original, op, JsonUtil.getValue(original, op.getString(FROM)).orElse(JsonValue.NULL));
    }

    private static Stream<Pair<JsonObject, JsonObject>> incremental(JsonObject original, Stream<JsonObject> patch) {
        return StreamUtil.takeWhile(patch, op -> Pair.pair(original, op), (pair, op) -> Pair.pair(Patch.incremental((JsonObject)pair.first, (JsonObject)pair.second), op), pair -> true);
    }

    private static JsonObject incremental(JsonObject original, JsonObject op) {
        return JsonUtil.createPatch(Factory.a(op)).apply(original).asJsonObject();
    }

    private static Stream<JsonObject> move(JsonObject original, JsonObject op) {
        return Stream.of(Patch.remove(original, op, FROM), Patch.copy(original, op));
    }

    private static Stream<JsonObject> objects(Stream<JsonValue> values) {
        return values.filter(JsonUtil::isObject).map(JsonValue::asJsonObject);
    }

    private static Stream<JsonObject> operation(JsonObject original, JsonObject op) {
        switch (JsonPatch.Operation.fromOperationName(op.getString(OP))) {
            case ADD: {
                return Stream.of(Patch.add(original, op));
            }
            case COPY: {
                return Stream.of(Patch.copy(original, op));
            }
            case MOVE: {
                return Patch.move(original, op);
            }
            case REMOVE: {
                return Stream.of(Patch.remove(original, op, PATH));
            }
            case REPLACE: {
                return Stream.of(Patch.replace(op));
            }
        }
        return Stream.empty();
    }

    private static JsonObject remove(JsonObject original, JsonObject op, String field) {
        String path = op.getString(field);
        return Patch.arrayValue(original, path).map(a -> Patch.set(a.path, Patch.removeFromArray(a))).orElseGet(() -> Patch.unset(path));
    }

    private static JsonValue removeFromArray(ArrayValue arrayValue) {
        return JsonUtil.remove(arrayValue.array, arrayValue.position);
    }

    private static JsonObject replace(JsonObject op) {
        return Patch.set(op.getString(PATH), (JsonValue)op.get(VALUE));
    }

    private static JsonObject set(String path, JsonValue value) {
        return Factory.o(Factory.f(SET, Factory.o(Factory.f(JsonUtil.toDotSeparated(path), value))));
    }

    private static JsonObject setInArray(ArrayValue arrayValue, JsonValue value) {
        return Factory.o(Factory.f(PUSH, Factory.o(Factory.f(JsonUtil.toDotSeparated(arrayValue.path), Factory.o(Factory.f(EACH, Factory.a(value)), Factory.f(POSITION, Factory.v(arrayValue.position)))))));
    }

    private static JsonObject unset(String path) {
        return Factory.o(Factory.f(UNSET, Factory.o(Factory.f(JsonUtil.toDotSeparated(path), Factory.v("")))));
    }

    public static List<Bson> updateOperators(JsonObject original, JsonPatch patch) {
        return JsonClient.fromJsonStream(Patch.updateOperators(original, Patch.objects(patch.toJsonArray().stream())));
    }

    public static JsonArray updateOperators(JsonObject original, JsonArray patch) {
        return Patch.updateOperators(original, Patch.objects(patch.stream())).reduce(JsonUtil.createArrayBuilder(), JsonArrayBuilder::add, (b1, b2) -> b1).build();
    }

    public static Stream<JsonObject> updateOperators(JsonObject original, Stream<JsonObject> patch) {
        return Patch.incremental(original, patch.filter(JsonUtil::isObject).map(JsonValue::asJsonObject)).flatMap(pair -> Patch.operation((JsonObject)pair.first, (JsonObject)pair.second));
    }

    private static class ArrayValue {
        private final JsonArray array;
        private final String path;
        private final int position;

        private ArrayValue(String path, int position, JsonArray array) {
            this.path = path;
            this.position = position;
            this.array = array;
        }
    }
}

