/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import javax.json.JsonObject;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Cmp;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;
import net.pincette.mongo.Operator;

class Relational {
    private Relational() {
    }

    static Operator asFunction(BiFunction<JsonValue, Features, RelOp> predicate) {
        return (value, features) -> (json, vars) -> JsonUtil.createValue(((RelOp)predicate.apply((JsonValue)value, (Features)features)).test(json, vars));
    }

    private static RelOp compare(JsonValue value, IntPredicate result, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementationsNum(implementations, json, vars, 2).filter(values -> Cmp.comparable((JsonValue)values.get(0), (JsonValue)values.get(1))).filter(values -> result.test(Cmp.compare((JsonValue)values.get(0), (JsonValue)values.get(1)))).isPresent();
    }

    static RelOp eq(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> Expression.applyImplementationsNum(implementations, json, vars, 2).filter(values -> ((JsonValue)values.get(0)).equals(values.get(1))).isPresent();
    }

    static RelOp gt(JsonValue value, Features features) {
        return Relational.compare(value, result -> result > 0, features);
    }

    static RelOp gte(JsonValue value, Features features) {
        return Relational.compare(value, result -> result >= 0, features);
    }

    static RelOp lt(JsonValue value, Features features) {
        return Relational.compare(value, result -> result < 0, features);
    }

    static RelOp lte(JsonValue value, Features features) {
        return Relational.compare(value, result -> result <= 0, features);
    }

    static RelOp ne(JsonValue value, Features features) {
        RelOp eq = Relational.eq(value, features);
        return (json, vars) -> !eq.test(json, vars);
    }

    static interface RelOp
    extends BiPredicate<JsonObject, Map<String, JsonValue>> {
    }
}

