/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import com.mongodb.TransactionOptions;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoClient;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import net.pincette.util.Util;

public class Session {
    private Session() {
    }

    public static CompletionStage<Void> abortTransaction(ClientSession session) {
        return net.pincette.rs.Util.emptyAsync(session.abortTransaction());
    }

    public static CompletionStage<Void> commitTransaction(ClientSession session) {
        return net.pincette.rs.Util.emptyAsync(session.commitTransaction());
    }

    public static CompletionStage<ClientSession> create(MongoClient client) {
        return net.pincette.rs.Util.asValueAsync(client.startSession());
    }

    public static <T> CompletionStage<T> inTransaction(Function<ClientSession, CompletionStage<T>> fn, ClientSession session) {
        return Session.inTransaction(fn, session, null);
    }

    public static <T> CompletionStage<T> inTransaction(Function<ClientSession, CompletionStage<T>> fn, ClientSession session, TransactionOptions options) {
        if (options != null) {
            session.startTransaction(options);
        } else {
            session.startTransaction();
        }
        return fn.apply(session).thenComposeAsync(result -> result != null ? Session.commitTransaction(session).thenApply(r -> result) : Session.abortTransaction(session).thenApply(r -> null)).exceptionally(e -> {
            Session.abortTransaction(session).toCompletableFuture().join();
            Util.rethrow(e);
            return null;
        });
    }
}

