/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;
import net.pincette.mongo.Util;
import net.pincette.util.Collections;
import net.pincette.util.StreamUtil;

class Sets {
    private Sets() {
    }

    static Implementation allElementsTrue(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> JsonUtil.createValue(Expression.applyImplementations(implementations, json, vars).filter(values -> values.stream().noneMatch(Expression::isFalse)).isPresent());
    }

    static Implementation anyElementsTrue(JsonValue value, Features features) {
        List<Implementation> implementations = Expression.implementations(value, features);
        return (json, vars) -> JsonUtil.createValue(Expression.applyImplementations(implementations, json, vars).filter(values -> values.stream().anyMatch(v -> !Expression.isFalse(v))).isPresent());
    }

    private static boolean notIn(JsonArray array, JsonValue value) {
        return !array.contains(value);
    }

    static Implementation setDifference(JsonValue value, Features features) {
        return Expression.arraysOperatorTwo(value, Sets::setDifference, features);
    }

    private static JsonValue setDifference(JsonArray a1, JsonArray a2) {
        return Util.toArray(a1.stream().filter(v -> Sets.notIn(a2, v)));
    }

    static Implementation setEquals(JsonValue value, Features features) {
        return Expression.arraysOperator(value, Sets::setEquals, features);
    }

    private static JsonValue setEquals(List<JsonArray> values) {
        return JsonUtil.createValue(values.isEmpty() || StreamUtil.slide(values.stream().map(HashSet::new), 2).map(pair -> ((HashSet)pair.get(0)).equals(pair.get(1))).reduce((r1, r2) -> r1 != false && r2 != false).orElse(false) != false);
    }

    static Implementation setIntersection(JsonValue value, Features features) {
        return Expression.arraysOperator(value, Sets::setIntersection, features);
    }

    private static JsonValue setIntersection(List<JsonArray> values) {
        return Sets.setOp(values, Collections::intersection);
    }

    static Implementation setIsSubset(JsonValue value, Features features) {
        return Expression.arraysOperatorTwo(value, Sets::setIsSubset, features);
    }

    private static JsonValue setIsSubset(JsonArray a1, JsonArray a2) {
        return JsonUtil.createValue(Collections.intersection(a1, a2).size() == a1.size());
    }

    private static JsonValue setOp(List<JsonArray> values, Function<Stream<Collection<JsonValue>>, Set<JsonValue>> op) {
        return Util.toArray(op.apply(Sets.sets(values)).stream());
    }

    static Implementation setUnion(JsonValue value, Features features) {
        return Expression.arraysOperator(value, Sets::setUnion, features);
    }

    private static JsonValue setUnion(List<JsonArray> values) {
        return Sets.setOp(values, Collections::union);
    }

    private static Stream<Collection<JsonValue>> sets(List<JsonArray> values) {
        return values.stream().map(HashSet::new);
    }
}

