/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.json.JsonNumber;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Expression;
import net.pincette.mongo.Features;
import net.pincette.mongo.Implementation;
import net.pincette.util.Collections;
import net.pincette.util.Util;

class Types {
    private static final String ARRAY_TYPE = "array";
    private static final String BOOL = "bool";
    private static final String DATE = "date";
    private static final String DECIMAL = "decimal";
    private static final String DOUBLE = "double";
    private static final String INPUT = "input";
    private static final String INT = "int";
    private static final String LONG = "long";
    private static final String OBJECT = "object";
    private static final String OBJECT_ID = "objectId";
    private static final String ON_ERROR = "onError";
    private static final String ON_NULL = "onNull";
    private static final String STRING_TYPE = "string";
    private static final String TO = "to";

    private Types() {
    }

    static Implementation convert(JsonValue value, Features features) {
        List<Implementation> implementations = Collections.list(Expression.memberFunction(value, INPUT, features), Expression.memberFunction(value, TO, features), Optional.ofNullable(Expression.memberFunction(value, ON_ERROR, features)).orElse((json, vars) -> JsonValue.NULL), Optional.ofNullable(Expression.memberFunction(value, ON_NULL, features)).orElse((json, vars) -> JsonValue.NULL));
        return (json, vars) -> Expression.applyImplementations(implementations, json, vars, fncs -> fncs.get(0) != null && fncs.get(1) != null).filter(values -> Expression.isScalar((JsonValue)values.get(0)) && (JsonUtil.isString((JsonValue)values.get(1)) || JsonUtil.isNumber((JsonValue)values.get(1))) && Expression.isScalar((JsonValue)values.get(2)) && Expression.isScalar((JsonValue)values.get(3))).map(values -> Util.tryToGetSilent(() -> (JsonValue)Types.op(Types.typeString((JsonValue)values.get(1))).apply((JsonValue)values.get(0))).map(result -> result.equals(JsonValue.NULL) ? (JsonValue)values.get(3) : result).orElseGet(() -> (JsonValue)values.get(2))).orElse(JsonValue.NULL);
    }

    private static JsonValue convertToBoolean(JsonValue value) {
        switch (value.getValueType()) {
            case NUMBER: {
                return JsonUtil.asNumber(value).bigDecimalValue().equals(BigDecimal.ZERO) ? JsonValue.FALSE : JsonValue.TRUE;
            }
            case STRING: {
                return JsonValue.TRUE;
            }
        }
        return value;
    }

    private static JsonValue convertToDecimal(JsonValue value) {
        switch (value.getValueType()) {
            case FALSE: {
                return JsonUtil.createValue(0);
            }
            case NUMBER: 
            case NULL: {
                return JsonUtil.createValue(JsonUtil.asNumber(value).bigDecimalValue());
            }
            case STRING: {
                return JsonUtil.isInstant(value) ? JsonUtil.createValue(new BigDecimal(JsonUtil.asInstant(value).toEpochMilli())) : JsonUtil.createValue(new BigDecimal(JsonUtil.asString(value).getString()));
            }
            case TRUE: {
                return JsonUtil.createValue(1);
            }
        }
        throw new UnsupportedOperationException(value.toString() + " toDecimal");
    }

    private static JsonValue convertToInteger(JsonValue value) {
        return JsonUtil.createValue(JsonUtil.asInt(Types.convertToDecimal(value)));
    }

    private static JsonValue convertToLong(JsonValue value) {
        return JsonUtil.createValue(JsonUtil.asLong(Types.convertToDecimal(value)));
    }

    private static JsonValue convertToString(JsonValue value) {
        switch (value.getValueType()) {
            case FALSE: {
                return JsonUtil.createValue("false");
            }
            case STRING: 
            case NULL: {
                return value;
            }
            case NUMBER: {
                return JsonUtil.createValue(Optional.of(JsonUtil.asNumber(value)).filter(JsonNumber::isIntegral).map(JsonNumber::longValue).map(String::valueOf).orElseGet(value::toString));
            }
            case TRUE: {
                return JsonUtil.createValue("true");
            }
        }
        throw new UnsupportedOperationException(value + " toString");
    }

    private static UnaryOperator<JsonValue> op(String type) {
        switch (type) {
            case "bool": {
                return Types::convertToBoolean;
            }
            case "double": 
            case "decimal": {
                return Types::convertToDecimal;
            }
            case "int": {
                return Types::convertToInteger;
            }
            case "long": {
                return Types::convertToLong;
            }
            case "string": {
                return Types::convertToString;
            }
        }
        throw new UnsupportedOperationException(type);
    }

    static Implementation toBool(JsonValue value, Features features) {
        return Types.toConvert(value, BOOL, features);
    }

    private static Implementation toConvert(JsonValue value, String type, Features features) {
        return Types.convert(JsonUtil.createObjectBuilder().add(INPUT, value).add(TO, type).build(), features);
    }

    static Implementation toDecimal(JsonValue value, Features features) {
        return Types.toConvert(value, DECIMAL, features);
    }

    static Implementation toDouble(JsonValue value, Features features) {
        return Types.toConvert(value, DOUBLE, features);
    }

    static Implementation toInt(JsonValue value, Features features) {
        return Types.toConvert(value, INT, features);
    }

    private static String toNumberTypeString(JsonValue value) {
        Supplier<String> tryDouble = () -> JsonUtil.isDouble(value) ? DOUBLE : DECIMAL;
        Supplier<String> tryLong = () -> JsonUtil.isLong(value) ? LONG : (String)tryDouble.get();
        return JsonUtil.isInt(value) ? INT : tryLong.get();
    }

    static Implementation toLong(JsonValue value, Features features) {
        return Types.toConvert(value, LONG, features);
    }

    static Implementation toString(JsonValue value, Features features) {
        return Types.toConvert(value, STRING_TYPE, features);
    }

    private static String toTypeString(JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                return ARRAY_TYPE;
            }
            case FALSE: 
            case TRUE: {
                return BOOL;
            }
            case NUMBER: {
                return Types.toNumberTypeString(value);
            }
            case OBJECT: {
                return OBJECT;
            }
            case STRING: {
                return STRING_TYPE;
            }
        }
        return null;
    }

    static Implementation type(JsonValue value, Features features) {
        Implementation implementation = Expression.implementation(value, features);
        return (json, vars) -> Optional.of((JsonValue)implementation.apply(json, vars)).map(Types::toTypeString).map(JsonUtil::createValue).orElse(JsonValue.NULL);
    }

    private static String typeString(JsonValue value) {
        return JsonUtil.isString(value) ? JsonUtil.asString(value).getString() : Types.typeString(JsonUtil.asInt(value));
    }

    private static String typeString(int code) {
        switch (code) {
            case 1: {
                return DOUBLE;
            }
            case 2: {
                return STRING_TYPE;
            }
            case 7: {
                return OBJECT_ID;
            }
            case 8: {
                return BOOL;
            }
            case 9: {
                return DATE;
            }
            case 16: {
                return INT;
            }
            case 18: {
                return LONG;
            }
            case 19: {
                return DECIMAL;
            }
        }
        return null;
    }
}

