/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.mongo;

import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import net.pincette.json.JsonUtil;
import net.pincette.mongo.Cmp;
import net.pincette.util.Pair;

public class Util {
    static final Logger logger = Logger.getLogger("net.pincette.mongo.expressions");
    private static final String TRACE = "$trace";

    private Util() {
    }

    public static int compare(JsonValue v1, JsonValue v2) {
        return Util.normalize(Optional.of(Util.typeValue(v1) - Util.typeValue(v2)).filter(result -> result != 0).orElseGet(() -> Cmp.compare(v1, v2)));
    }

    static Optional<String> key(JsonObject expression) {
        return Optional.of(expression.keySet()).filter(keys -> keys.size() == 1).map(keys -> (String)keys.iterator().next());
    }

    static int normalize(int result) {
        return Integer.min(1, Math.abs(result)) * (result < 0 ? -1 : 1);
    }

    static JsonValue toArray(Stream<JsonValue> values) {
        return values.reduce(JsonUtil.createArrayBuilder(), JsonArrayBuilder::add, (b1, b2) -> b1).build();
    }

    private static int typeValue(JsonValue value) {
        if (value.equals(JsonValue.NULL)) {
            return 2;
        }
        if (JsonUtil.isNumber(value)) {
            return 3;
        }
        if (JsonUtil.isString(value) && !JsonUtil.isDate(value) && !JsonUtil.isInstant(value)) {
            return 4;
        }
        if (JsonUtil.isObject(value)) {
            return 5;
        }
        if (JsonUtil.isArray(value)) {
            return 6;
        }
        if (value.equals(JsonValue.TRUE) || value.equals(JsonValue.FALSE)) {
            return 9;
        }
        if (JsonUtil.isDate(value)) {
            return 10;
        }
        if (JsonUtil.isInstant(value)) {
            return 11;
        }
        return Integer.MAX_VALUE;
    }

    static Pair<JsonValue, Boolean> unwrapTrace(JsonValue expression) {
        return JsonUtil.isObject(expression) ? Util.key(expression.asJsonObject()).filter(key -> key.equals(TRACE)).map(key -> Pair.pair(expression.asJsonObject().getValue("/" + key), true)).orElseGet(() -> Pair.pair(expression, false)) : Pair.pair(expression, false);
    }

    static Pair<JsonObject, Boolean> unwrapTrace(JsonObject expression) {
        Pair<JsonValue, Boolean> unwrapped = Util.unwrapTrace((JsonValue)expression);
        return Pair.pair(((JsonValue)unwrapped.first).asJsonObject(), (Boolean)unwrapped.second);
    }
}

