/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.rs;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Stream;
import net.pincette.util.Util;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class Accumulator<T, U>
implements Subscriber<T> {
    private final List<T> list = new ArrayList<T>();
    private final CompletableFuture<U> future = new CompletableFuture();
    private final Function<Stream<T>, CompletionStage<U>> reducer;
    private Subscription subscription;

    public Accumulator(Function<Stream<T>, CompletionStage<U>> reducer) {
        this.reducer = reducer;
    }

    public CompletionStage<U> get() {
        return this.future;
    }

    @Override
    public void onComplete() {
        this.reducer.apply(this.list.stream()).thenAccept(this.future::complete);
    }

    @Override
    public void onError(Throwable t) {
        Util.rethrow(t);
    }

    @Override
    public void onNext(T value) {
        this.list.add(value);
        this.subscription.request(1L);
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }
}

