/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.rs;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import net.pincette.function.SideEffect;
import net.pincette.rs.Util;
import net.pincette.util.Util;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class BlockingSubscriber<T>
implements Subscriber<T>,
Iterable<T> {
    private final Iterator<T> iterator = new Elements();
    private final Queue<T> queue = new ConcurrentLinkedQueue<T>();
    private final long requestSize;
    private final Spliterator<T> spliterator = new SplitElements();
    private final Thread thread = Thread.currentThread();
    private boolean complete;
    private Subscription subscription;

    public BlockingSubscriber() {
        this(100L);
    }

    public BlockingSubscriber(long requestSize) {
        this.requestSize = requestSize;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    private void more() {
        if (this.subscription != null) {
            this.subscription.request(this.requestSize);
        }
    }

    @Override
    public void onComplete() {
        this.complete = true;
        LockSupport.unpark(this.thread);
    }

    @Override
    public void onError(Throwable throwable) {
        this.complete = true;
        LockSupport.unpark(this.thread);
        throw new Util.GeneralException(throwable);
    }

    @Override
    public void onNext(T t) {
        this.queue.add(t);
        if ((long)this.queue.size() >= this.requestSize) {
            LockSupport.unpark(this.thread);
        }
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        this.more();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.spliterator;
    }

    private class SplitElements
    implements Spliterator<T> {
        private SplitElements() {
        }

        @Override
        public int characteristics() {
            return 1040;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return BlockingSubscriber.this.iterator.hasNext() && SideEffect.run(() -> action.accept((Object)BlockingSubscriber.this.iterator.next())).andThenGet(() -> true) != false;
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }
    }

    private class Elements
    implements Iterator<T> {
        private Elements() {
        }

        @Override
        public boolean hasNext() {
            return !BlockingSubscriber.this.queue.isEmpty() || !BlockingSubscriber.this.complete && SideEffect.run(this::park).andThenGet(this::hasNext) != false;
        }

        @Override
        public T next() {
            if (BlockingSubscriber.this.subscription == null || BlockingSubscriber.this.queue.isEmpty()) {
                throw new NoSuchElementException();
            }
            return BlockingSubscriber.this.queue.poll();
        }

        private boolean noData() {
            return BlockingSubscriber.this.subscription == null || !BlockingSubscriber.this.complete && BlockingSubscriber.this.queue.isEmpty();
        }

        private void park() {
            BlockingSubscriber.this.more();
            while (this.noData()) {
                Util.parking(this, BlockingSubscriber.this.requestSize * 10L);
            }
        }
    }
}

