/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.rs;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class Buffered<T, R>
implements Processor<T, R> {
    private final Deque<T> buf = new ConcurrentLinkedDeque<T>();
    private final Function<Deque<T>, R> consumerBuffer;
    private final int size;
    private boolean available = true;
    private boolean error;
    private int requested;
    private Subscriber<? super R> subscriber;
    private Subscription subscription;

    Buffered(int size, Function<Deque<T>, R> consumerBuffer) {
        if (size < 1) {
            throw new IllegalArgumentException("Buffer size should be at least 1.");
        }
        this.size = size;
        this.consumerBuffer = consumerBuffer;
    }

    private void emit() {
        if (this.subscriber != null && this.subscription != null && !this.error) {
            this.flush();
            if (this.available && this.buf.isEmpty()) {
                this.available = false;
                this.subscription.request(this.size);
            }
        }
    }

    private void flush() {
        while (this.requested > 0 && !this.buf.isEmpty()) {
            --this.requested;
            this.subscriber.onNext(this.consumerBuffer.apply(this.buf));
        }
    }

    private void notifySubscriber() {
        this.subscriber.onSubscribe(new Backpressure());
    }

    @Override
    public void onComplete() {
        if (this.subscriber != null && !this.error) {
            this.flush();
            this.subscriber.onComplete();
        }
    }

    @Override
    public void onError(Throwable t) {
        this.error = true;
        if (this.subscriber != null) {
            this.subscriber.onError(t);
        }
    }

    @Override
    public void onNext(T t) {
        this.buf.addFirst(t);
        if (this.buf.size() == this.size) {
            this.available = true;
            this.emit();
        }
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        if (this.subscriber != null) {
            this.notifySubscriber();
        }
    }

    @Override
    public void subscribe(Subscriber<? super R> subscriber) {
        this.subscriber = subscriber;
        if (subscriber != null && this.subscription != null) {
            this.notifySubscriber();
        }
    }

    private class Backpressure
    implements Subscription {
        private Backpressure() {
        }

        @Override
        public void cancel() {
            if (Buffered.this.subscription != null) {
                Buffered.this.subscription.cancel();
            }
        }

        @Override
        public void request(long number) {
            if (number > 0L) {
                Buffered.this.requested = (int)((long)Buffered.this.requested + number);
                Buffered.this.emit();
            }
        }
    }
}

