/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.rs;

import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.pincette.rs.After;
import net.pincette.rs.Async;
import net.pincette.rs.AsyncProcessor;
import net.pincette.rs.Before;
import net.pincette.rs.Buffer;
import net.pincette.rs.Filter;
import net.pincette.rs.First;
import net.pincette.rs.Last;
import net.pincette.rs.Mapper;
import net.pincette.rs.NotFilter;
import net.pincette.rs.Per;
import net.pincette.rs.Separator;
import net.pincette.rs.Until;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;

public class Chain<T> {
    private final Publisher<T> publisher;

    private Chain(Publisher<T> publisher) {
        this.publisher = publisher;
    }

    public static <T> Chain<T> with(Publisher<T> publisher) {
        return new Chain<T>(publisher);
    }

    public Chain<T> after(T value) {
        return this.map(new After<T>(value));
    }

    public Chain<T> after(Supplier<T> value) {
        return this.map(new After<T>(value));
    }

    public Chain<T> before(T value) {
        return this.map(new Before<T>(value));
    }

    public Chain<T> before(Supplier<T> value) {
        return this.map(new Before<T>(value));
    }

    public Chain<T> buffer(int size) {
        return this.map(new Buffer(size));
    }

    public Chain<T> filter(Predicate<T> predicate) {
        return this.map(new Filter<T>(predicate));
    }

    public Chain<T> first() {
        return this.map(new First());
    }

    public Publisher<T> get() {
        return this.publisher;
    }

    public Chain<T> last() {
        return this.map(new Last());
    }

    public <R> Chain<R> map(Processor<T, R> processor) {
        this.publisher.subscribe(processor);
        return new Chain<T>(processor);
    }

    public Chain<T> map(AsyncProcessor<T> processor) {
        this.publisher.subscribe(processor);
        return new Chain<T>(processor);
    }

    public <R> Chain<R> map(Function<T, R> function) {
        return this.map(new Mapper<T, R>(function));
    }

    public <R> Chain<R> mapAsync(Function<T, CompletionStage<R>> function) {
        Mapper processor = new Mapper(function);
        Async asyncProcessor = new Async();
        this.publisher.subscribe(processor);
        processor.subscribe(asyncProcessor);
        return new Chain(asyncProcessor);
    }

    public Chain<T> notFilter(Predicate<T> predicate) {
        return this.map(new NotFilter<T>(predicate));
    }

    public Chain<List<T>> per(int size) {
        return this.map(new Per(size));
    }

    public Chain<T> separate(T value) {
        return this.map(new Separator<T>(value));
    }

    public Chain<T> separate(Supplier<T> value) {
        return this.map(new Separator<T>(value));
    }

    public Chain<T> until(Predicate<T> predicate) {
        return this.map(new Until<T>(predicate));
    }
}

