/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.rs;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class Fanout<T>
implements Subscriber<T> {
    private final ConcurrentMap<Backpressure, Boolean> requests = new ConcurrentHashMap<Backpressure, Boolean>();
    private final List<Subscriber<T>> subscribers;
    private boolean complete;
    private Subscription subscription;

    private Fanout(List<Subscriber<T>> subscribers) {
        this.subscribers = subscribers;
        subscribers.forEach(s -> s.onSubscribe(new Backpressure()));
    }

    public static <T> Subscriber<T> of(List<Subscriber<T>> subscribers) {
        return new Fanout<T>(subscribers);
    }

    @SafeVarargs
    public static <T> Subscriber<T> of(Subscriber<T> ... subscribers) {
        return new Fanout<T>(Arrays.asList(subscribers));
    }

    @Override
    public void onComplete() {
        this.complete = true;
        this.subscribers.forEach(Subscriber::onComplete);
    }

    @Override
    public void onError(Throwable t) {
        this.subscribers.forEach(s -> s.onError(t));
    }

    @Override
    public void onNext(T t) {
        if (!this.complete) {
            this.subscribers.forEach(s -> s.onNext(t));
        }
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    private class Backpressure
    implements Subscription {
        private Backpressure() {
        }

        @Override
        public void cancel() {
            if (Fanout.this.subscription != null) {
                Fanout.this.subscription.cancel();
            }
        }

        @Override
        public void request(long l) {
            if (!Fanout.this.complete && Fanout.this.subscription != null) {
                Fanout.this.requests.put(this, true);
                if (Fanout.this.requests.size() == Fanout.this.subscribers.size()) {
                    Fanout.this.requests.clear();
                    Fanout.this.subscription.request(1L);
                }
            }
        }
    }
}

