/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.rs;

import net.pincette.function.ConsumerWithException;
import net.pincette.function.RunnableWithException;
import net.pincette.util.Util;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class LambdaSubscriber<T>
implements Subscriber<T> {
    private final RunnableWithException complete;
    private final ConsumerWithException<Throwable> error;
    private final ConsumerWithException<T> next;
    private final ConsumerWithException<Subscription> subscribe;
    private Subscription subscription;

    public LambdaSubscriber(ConsumerWithException<T> next) {
        this(next, null, null, null);
    }

    public LambdaSubscriber(ConsumerWithException<T> next, RunnableWithException complete) {
        this(next, complete, null, null);
    }

    public LambdaSubscriber(ConsumerWithException<T> next, RunnableWithException complete, ConsumerWithException<Throwable> error) {
        this(next, complete, error, null);
    }

    public LambdaSubscriber(ConsumerWithException<T> next, RunnableWithException complete, ConsumerWithException<Throwable> error, ConsumerWithException<Subscription> subscribe) {
        this.next = next;
        this.complete = complete;
        this.error = error;
        this.subscribe = subscribe;
    }

    @Override
    public void onComplete() {
        if (this.complete != null) {
            Util.tryToDoRethrow(this.complete);
        }
    }

    @Override
    public void onError(Throwable t) {
        if (this.error == null) {
            throw new Util.GeneralException(t);
        }
        Util.tryToDoRethrow(() -> this.error.accept(t));
    }

    @Override
    public void onNext(T o) {
        if (this.subscription != null) {
            if (this.next != null) {
                Util.tryToDoRethrow(() -> this.next.accept(o));
            }
            this.subscription.request(1L);
        }
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (this.subscribe != null) {
            Util.tryToDoRethrow(() -> this.subscribe.accept(s));
        }
        this.subscription = s;
        s.request(1L);
    }
}

