/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.rs;

import java.util.Optional;
import java.util.function.Function;
import net.pincette.function.SideEffect;
import net.pincette.util.Util;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class Mapper<T, R>
implements Processor<T, R> {
    private final Function<T, R> map;
    protected Subscription subscription;
    private boolean error;
    private Subscriber<? super R> subscriber;

    public Mapper(Function<T, R> map) {
        this.map = map;
    }

    protected boolean canRequestMore(long number) {
        return true;
    }

    protected void complete() {
        if (this.subscription != null) {
            this.subscription.cancel();
        }
        this.onComplete();
    }

    protected void more() {
        this.more(1L);
    }

    protected void more(long number) {
        if (this.subscription != null && number > 0L && !this.error && this.canRequestMore(number)) {
            this.subscription.request(number);
        }
    }

    private R newValue(T value) {
        return Optional.ofNullable(value).flatMap(v -> Util.tryToGet(() -> this.map.apply(v), e -> SideEffect.run(() -> this.onError((Throwable)e)).andThenGet(() -> null))).orElse(null);
    }

    private void notifySubscriber() {
        this.subscriber.onSubscribe(new Backpressure());
    }

    @Override
    public void onComplete() {
        if (this.subscriber != null && !this.error) {
            this.subscriber.onComplete();
        }
    }

    @Override
    public void onError(Throwable t) {
        this.setError(true);
        if (this.subscriber != null) {
            this.subscriber.onError(t);
        }
    }

    @Override
    public void onNext(T value) {
        if (this.subscriber != null) {
            R newValue = this.newValue(value);
            if (newValue != null) {
                this.subscriber.onNext(newValue);
            } else {
                this.more();
            }
        }
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        if (this.subscriber != null) {
            this.notifySubscriber();
        }
    }

    protected void setError(boolean value) {
        this.error = value;
    }

    @Override
    public void subscribe(Subscriber<? super R> subscriber) {
        this.subscriber = subscriber;
        if (subscriber != null && this.subscription != null) {
            this.notifySubscriber();
        }
    }

    private class Backpressure
    implements Subscription {
        private Backpressure() {
        }

        @Override
        public void cancel() {
            if (Mapper.this.subscription != null) {
                Mapper.this.subscription.cancel();
            }
        }

        @Override
        public void request(long number) {
            Mapper.this.more(number);
        }
    }
}

