/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.rs;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.pincette.rs.LambdaSubscriber;
import net.pincette.util.Util;
import org.reactivestreams.Publisher;

public class Reducer {
    private Reducer() {
    }

    public static <T> CompletionStage<Void> forEach(Publisher<T> publisher, Consumer<T> consumer) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        publisher.subscribe(new LambdaSubscriber<Object>(consumer::accept, () -> future.complete(null), future::completeExceptionally));
        return future;
    }

    public static <T> void forEachJoin(Publisher<T> publisher, Consumer<T> consumer) {
        Reducer.forEach(publisher, consumer).toCompletableFuture().join();
    }

    public static <T, U> CompletionStage<U> reduce(Publisher<T> publisher, Supplier<U> identity, BiFunction<U, T, U> accumulator) {
        CompletableFuture future = new CompletableFuture();
        State state = new State(identity.get());
        publisher.subscribe(new LambdaSubscriber<Object>(value -> Util.tryToDo(() -> state.set(accumulator.apply(state.value, value)), e -> {
            future.completeExceptionally((Throwable)e);
            Util.rethrow(e);
        }), () -> future.complete(state.value), future::completeExceptionally));
        return future;
    }

    public static <T> CompletionStage<Optional<T>> reduce(Publisher<T> publisher, BinaryOperator<T> accumulator) {
        return Reducer.reduce(publisher, () -> new State<Object>(null), (state, value) -> state.set(state.value != null ? accumulator.apply(state.value, value) : value)).thenApply(result -> Optional.ofNullable(result.value));
    }

    public static <T, U> U reduceJoin(Publisher<T> publisher, Supplier<U> identity, BiFunction<U, T, U> accumulator) {
        return Reducer.reduce(publisher, identity, accumulator).toCompletableFuture().join();
    }

    public static <T> Optional<T> reduceJoin(Publisher<T> publisher, BinaryOperator<T> accumulator) {
        return Reducer.reduce(publisher, accumulator).toCompletableFuture().join();
    }

    private static class State<T> {
        private T value;

        private State(T value) {
            this.value = value;
        }

        private State<T> set(T value) {
            this.value = value;
            return this;
        }
    }
}

