/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.rs;

import java.util.Arrays;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class Source<T>
implements Publisher<T> {
    private final List<T> list;
    private boolean complete;
    private int position;
    private Subscriber<? super T> subscriber;

    private Source(List<T> list) {
        this.list = list;
    }

    public static <T> Publisher<T> of(List<T> values) {
        return new Source<T>(values);
    }

    public static <T> Publisher<T> of(T ... values) {
        return new Source<Object>(Arrays.asList((Object[])values.clone()));
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        this.subscriber = subscriber;
        this.position = 0;
        subscriber.onSubscribe(new Cursor());
    }

    private class Cursor
    implements Subscription {
        private Cursor() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public void request(long n) {
            for (long i = 0L; i < n && Source.this.position < Source.this.list.size(); ++i) {
                Source.this.subscriber.onNext(Source.this.list.get(Source.this.position++));
            }
            if (Source.this.position >= Source.this.list.size() && !Source.this.complete) {
                Source.this.complete = true;
                Source.this.subscriber.onComplete();
            }
        }
    }
}

