/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.util;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.pincette.function.FunctionWithException;
import net.pincette.function.SupplierWithException;
import net.pincette.util.Util;

public class AsyncBuilder<T> {
    private final CompletionStage<Optional<T>> object;

    private AsyncBuilder(CompletionStage<Optional<T>> object) {
        this.object = object;
    }

    public static <T> AsyncBuilder<T> create(SupplierWithException<T> supplier) {
        return new AsyncBuilder<T>(Util.tryToGetRethrow(supplier).map(Optional::of).map(CompletableFuture::completedFuture).orElse(null));
    }

    private static <T> CompletionStage<Optional<T>> next(CompletionStage<Optional<T>> object, FunctionWithException<T, CompletionStage<Optional<T>>> set) {
        return object.thenComposeAsync(obj -> obj.flatMap(o -> Util.tryToGetRethrow(() -> (CompletionStage)set.apply(o))).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty())));
    }

    public CompletionStage<Optional<T>> build() {
        return this.object;
    }

    public AsyncBuilder<T> update(FunctionWithException<T, CompletionStage<Optional<T>>> set) {
        return new AsyncBuilder<T>(AsyncBuilder.next(this.object, set));
    }
}

