/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.util;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.pincette.function.BiConsumerWithException;
import net.pincette.function.ConsumerWithException;
import net.pincette.function.SupplierWithException;
import net.pincette.util.Util;

public class Builder<T> {
    private final T object;

    private Builder(T object) {
        this.object = object;
    }

    public static <T> Builder<T> create(SupplierWithException<T> supplier) {
        return new Builder<Object>(Util.tryToGetRethrow(supplier).orElse(null));
    }

    public T build() {
        return this.object;
    }

    public Builder<T> update(ConsumerWithException<T> set) {
        Util.tryToDoRethrow(() -> set.accept(this.object));
        return this;
    }

    public Builder<T> updateIf(Predicate<T> predicate, ConsumerWithException<T> set) {
        return predicate.test(this.object) ? this.update(set) : this;
    }

    public <U> Builder<T> updateIf(Supplier<Optional<U>> value, BiConsumerWithException<T, U> set) {
        return value.get().map(v -> this.update(o -> set.accept(o, v))).orElse(this);
    }
}

