/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.pincette.function.SideEffect;
import net.pincette.util.Pair;
import net.pincette.util.StreamUtil;
import net.pincette.util.Util;

public class Collections {
    private Collections() {
    }

    public static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<? super K, ? extends V> fn) {
        return (V)Optional.ofNullable(map.get(key)).orElseGet(() -> Optional.of(fn.apply((Object)key)).map(v -> SideEffect.run(() -> map.put(key, v)).andThenGet(() -> v)).orElse(null));
    }

    public static <K, V> V computeIfPresent(Map<K, V> map, K key, BiFunction<? super K, ? super V, ? extends V> fn) {
        return Optional.ofNullable(map.get(key)).map(v -> Optional.ofNullable(fn.apply((Object)key, (Object)v)).map(val -> SideEffect.run(() -> map.put(key, v)).andThenGet(() -> val)).orElseGet(() -> SideEffect.run(() -> map.remove(key)).andThenGet(() -> null))).orElse(null);
    }

    @SafeVarargs
    public static <T> List<T> concat(Collection<T> ... collections) {
        return Collections.concat(Arrays.stream(collections));
    }

    public static <T> List<T> concat(Stream<Collection<T>> collections) {
        return collections.flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <T> Set<T> difference(Collection<T> c1, Collection<T> c2) {
        HashSet<T> result = new HashSet<T>(c1);
        result.removeAll(c2);
        return result;
    }

    public static Map<String, Object> expand(Map<String, ?> map, String delimiter) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        map.forEach((k, v) -> {
            String[] segments = k.split(Pattern.quote(delimiter));
            Arrays.stream(Arrays.copyOf(segments, segments.length - 1)).reduce(result, (m, segment) -> (Map)m.computeIfAbsent(segment, s -> new HashMap()), (m1, m2) -> m1).put(segments[segments.length - 1], v);
        });
        return result;
    }

    public static Map<String, Object> flatten(Map<String, ?> map, String delimiter) {
        return map.entrySet().stream().flatMap(e -> e.getValue() instanceof Map ? Collections.flatten((Map)e.getValue(), delimiter).entrySet().stream().map(sub -> Pair.pair((String)e.getKey() + delimiter + (String)sub.getKey(), sub.getValue())) : Stream.of(Pair.pair((String)e.getKey(), e.getValue()))).collect(Collectors.toMap(p -> (String)p.first, p -> p.second));
    }

    public static <K, V> Optional<V> get(Map<K, V> map, K key) {
        return Optional.ofNullable(map.get(key));
    }

    public static <T> Stream<Pair<T, Integer>> indexedStream(List<T> list) {
        return StreamUtil.stream(Util.countingIterator(list.iterator()));
    }

    @SafeVarargs
    public static <T> Set<T> intersection(Collection<T> ... collections) {
        return Collections.intersection(Arrays.stream(collections));
    }

    public static <T> Set<T> intersection(Stream<Collection<T>> collections) {
        return collections.map(HashSet::new).reduce((s1, s2) -> SideEffect.run(() -> s1.retainAll((Collection<?>)s2)).andThenGet(() -> s1)).map(Set.class::cast).orElseGet(java.util.Collections::emptySet);
    }

    @SafeVarargs
    public static <T> List<T> list(T ... elements) {
        return Arrays.stream(elements).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <K, V> Map<K, V> map(Pair<K, V> ... pairs) {
        return Collections.map(Arrays.stream(pairs));
    }

    public static <K, V> Map<K, V> map(Stream<Pair<K, V>> pairs) {
        return pairs.collect(Collectors.toMap(pair -> pair.first, pair -> pair.second));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> merge(Map<K, V> ... maps) {
        return Collections.merge(Arrays.stream(maps));
    }

    public static <K, V> Map<K, V> merge(Stream<Map<K, V>> maps) {
        return maps.flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2));
    }

    public static <T, U> Set<Pair<T, U>> multiply(Set<T> s1, Set<U> s2) {
        return s1.stream().flatMap(el1 -> s2.stream().map(el2 -> Pair.pair(el1, el2))).collect(Collectors.toSet());
    }

    public static <K, V> Map<K, V> put(Map<K, V> map, K key, V value) {
        HashMap<K, V> result = new HashMap<K, V>(map);
        result.put(key, value);
        return result;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> remove(Map<K, V> map, K ... keys) {
        HashMap<K, V> result = new HashMap<K, V>(map);
        Arrays.stream(keys).forEach(result::remove);
        return result;
    }

    public static <T> Iterator<T> reverse(List<T> list) {
        return list.isEmpty() ? list.iterator() : new ReverseIterator<T>(list);
    }

    @SafeVarargs
    public static <T> Set<T> set(T ... elements) {
        return Arrays.stream(elements).collect(Collectors.toSet());
    }

    public static <T> List<T> shiftDown(List<T> list, int positions) {
        return !list.isEmpty() ? Collections.shiftDown(list, positions, list.get(list.size() - 1)) : list;
    }

    public static <T> List<T> shiftDown(List<T> list, int positions, T newElement) {
        int pos = Integer.min(positions, list.size());
        return !list.isEmpty() ? Collections.concat(list.subList(pos, list.size()), java.util.Collections.nCopies(pos, newElement)) : list;
    }

    public static <T> List<T> shiftUp(List<T> list, int positions) {
        return !list.isEmpty() ? Collections.shiftUp(list, positions, list.get(0)) : list;
    }

    public static <T> List<T> shiftUp(List<T> list, int positions, T newElement) {
        int pos = Integer.min(positions, list.size());
        return !list.isEmpty() ? Collections.concat(java.util.Collections.nCopies(pos, newElement), list.subList(0, list.size() - pos)) : list;
    }

    @SafeVarargs
    public static <T> Set<T> union(Collection<T> ... collections) {
        return Collections.union(Arrays.stream(collections));
    }

    public static <T> Set<T> union(Stream<Collection<T>> collections) {
        return collections.flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static class ReverseIterator<T>
    implements Iterator<T> {
        private final ListIterator<T> iterator;

        private ReverseIterator(List<T> list) {
            this.iterator = list.listIterator(list.size());
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterator.previous();
        }
    }
}

