/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.util;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.pincette.function.SideEffect;
import net.pincette.util.Or;
import net.pincette.util.Pair;
import net.pincette.util.StreamUtil;
import net.pincette.util.Util;

public class Expressions {
    private static final Pattern TOKENS = Pattern.compile("(\\()|(\\))|(!)|([a-zA-Z][\\w]*)|(=)|(\\!=)|(<)|(>)|(<=)|(>=)|(\\+)|(-)|(\\*)|(/)|(&&)|(\\|\\|)|(-?\\d+\\.?\\d*)|('[^']*')|(\"[^\"]*\")|(\\s+)");
    private static final int LEFT_BRACE = 1;
    private static final int RIGHT_BRACE = 2;
    private static final int NOT = 3;
    private static final int IDENTIFIER = 4;
    private static final int EQUAL = 5;
    private static final int NOT_EQUAL = 6;
    private static final int LESS_THAN = 7;
    private static final int GREATER_THAN = 8;
    private static final int LESS_THAN_EQUAL = 9;
    private static final int GREATER_THAN_EQUAL = 10;
    private static final int PLUS = 11;
    private static final int MINUS = 12;
    private static final int MULTIPLY = 13;
    private static final int DIVIDE = 14;
    private static final int AND = 15;
    private static final int OR = 16;
    private static final int NUMBER = 17;
    private static final int SINGLE_QUOTED = 18;
    private static final int DOUBLE_QUOTED = 19;
    private static final int WHITESPACE = 20;
    private static final int[] TOKEN_VALUES = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};

    private static Expr braced(Supplier<Value> get, Runnable pushback) {
        Function<Pair, Expr> ifRightBrace = pair -> ((Value)pair.second).token == 2 ? (Expr)pair.first : SideEffect.run(pushback).andThenGet(() -> null);
        return get.get().token == 1 ? (Expr)Optional.ofNullable(Expressions.expr(get, pushback)).map(expr -> Pair.pair(expr, (Value)get.get())).map(ifRightBrace).orElse(null) : SideEffect.run(pushback).andThenGet(() -> null);
    }

    private static Expr expr(Supplier<Value> get, Runnable pushback) {
        return Optional.ofNullable(Expressions.rest(get, pushback)).map(rest -> Pair.pair(rest, Expressions.exprPrime(get, pushback))).map(pair -> pair.second != null ? new Operator((Expr)pair.first, ((Operator)pair.second).op, ((Operator)pair.second).operand2) : (Expr)pair.first).orElse(null);
    }

    private static Operator exprPrime(Supplier<Value> get, Runnable pushback) {
        int token = get.get().token;
        return Expressions.isBinaryOperator(token) ? (Operator)Optional.ofNullable(Expressions.expr(get, pushback)).map(expr -> new Operator(null, token, (Expr)expr)).orElse(null) : SideEffect.run(pushback).andThenGet(() -> null);
    }

    private static int findGroup(Matcher matcher) {
        return Arrays.stream(TOKEN_VALUES).filter(value -> matcher.start(value) != -1).findFirst().orElse(-1);
    }

    private static Object getValue(int token, String s) {
        switch (token) {
            case 17: {
                return Double.parseDouble(s);
            }
            case 4: {
                return s;
            }
            case 18: 
            case 19: {
                return s.substring(1, s.length() - 1);
            }
        }
        return null;
    }

    private static Identifier identifier(Supplier<Value> get, Runnable pushback) {
        Value value = get.get();
        return value.token == 4 ? new Identifier((String)value.val) : SideEffect.run(pushback).andThenGet(() -> null);
    }

    private static boolean isBinaryOperator(int token) {
        return token == 11 || token == 12 || token == 15 || token == 16 || token == 5 || token == 6 || token == 7 || token == 8 || token == 9 || token == 10 || token == 13 || token == 14;
    }

    private static Not not(Supplier<Value> get, Runnable pushback) {
        return get.get().token == 3 ? (Not)Optional.ofNullable(Expressions.expr(get, pushback)).map(x$0 -> new Not((Expr)x$0)).orElse(null) : SideEffect.run(pushback).andThenGet(() -> null);
    }

    private static NumberExpr number(Supplier<Value> get, Runnable pushback) {
        Value value = get.get();
        return value.token == 17 ? new NumberExpr((Double)value.val) : SideEffect.run(pushback).andThenGet(() -> null);
    }

    public static Optional<Expr> parse(String s) {
        Tokens tokens = new Tokens(Expressions.tokenize(s));
        return Optional.ofNullable(Expressions.expr(() -> tokens.get(), () -> tokens.pushback()));
    }

    private static Expr rest(Supplier<Value> get, Runnable pushback) {
        return Or.tryWith(() -> Expressions.braced(get, pushback)).or(() -> Expressions.not(get, pushback)).or(() -> Expressions.identifier(get, pushback)).or(() -> Expressions.number(get, pushback)).or(() -> Expressions.string(get, pushback)).get().orElse(null);
    }

    private static StringExpr string(Supplier<Value> get, Runnable pushback) {
        Value value = get.get();
        return value.token == 18 || value.token == 19 ? new StringExpr((String)value.val) : SideEffect.run(pushback).andThenGet(() -> null);
    }

    private static List<Value> tokenize(String s) {
        Matcher matcher = TOKENS.matcher(s);
        return StreamUtil.stream(Util.matcherIterator(matcher, m -> new MatchedToken(Expressions.findGroup(m), (Matcher)m))).filter(token -> token.token != 20).map(token -> new Value(token.token, Expressions.getValue(token.token, s.substring(token.start, token.end)))).collect(Collectors.toList());
    }

    private static class Value {
        private final int token;
        private final Object val;

        private Value(int token, Object val) {
            this.token = token;
            this.val = val;
        }
    }

    private static class Tokens {
        private final List<Value> toks;
        private int position;

        private Tokens(List<Value> toks) {
            this.toks = toks;
        }

        private Value get() {
            return this.position >= this.toks.size() ? new Value(-1, null) : this.toks.get(this.position++);
        }

        private void pushback() {
            --this.position;
        }
    }

    private static class StringExpr
    implements Expr {
        private final String value;

        private StringExpr(String value) {
            this.value = value;
        }

        @Override
        public Object evaluate(Function<String, Object> evaluator) {
            return this.value;
        }
    }

    private static class Operator
    implements Expr {
        private final Expr operand1;
        private final Expr operand2;
        private final int op;

        private Operator(Expr operand1, int op, Expr operand2) {
            this.operand1 = operand1;
            this.op = op;
            this.operand2 = operand2;
        }

        private static BiFunction<Object, Object, Object> getBinaryOperator(int operator) {
            switch (operator) {
                case 15: {
                    return (left, right) -> (Boolean)left != false && (Boolean)right != false;
                }
                case 16: {
                    return (left, right) -> (Boolean)left != false || (Boolean)right != false;
                }
                case 5: {
                    return Objects::equals;
                }
                case 6: {
                    return (left, right) -> !left.equals(right);
                }
                case 7: {
                    return (left, right) -> ((Comparable)left).compareTo(right) < 0;
                }
                case 8: {
                    return (left, right) -> ((Comparable)left).compareTo(right) > 0;
                }
                case 9: {
                    return (left, right) -> ((Comparable)left).compareTo(right) <= 0;
                }
                case 10: {
                    return (left, right) -> ((Comparable)left).compareTo(right) >= 0;
                }
                case 11: {
                    return (left, right) -> ((Number)left).doubleValue() + ((Number)right).doubleValue();
                }
                case 12: {
                    return (left, right) -> ((Number)left).doubleValue() - ((Number)right).doubleValue();
                }
                case 13: {
                    return (left, right) -> ((Number)left).doubleValue() * ((Number)right).doubleValue();
                }
                case 14: {
                    return (left, right) -> ((Number)left).doubleValue() / ((Number)right).doubleValue();
                }
            }
            return (left, right) -> null;
        }

        private static boolean isCompatible(int operator, Object value) {
            switch (operator) {
                case 15: 
                case 16: {
                    return value instanceof Boolean;
                }
                case 5: 
                case 6: {
                    return true;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return value instanceof Comparable;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    return value instanceof Number;
                }
            }
            return false;
        }

        @Override
        public Object evaluate(Function<String, Object> evaluator) {
            Object left = this.operand1.evaluate(evaluator);
            Object right = this.operand2.evaluate(evaluator);
            return left != null && right != null && left.getClass().isAssignableFrom(right.getClass()) && Operator.isCompatible(this.op, left) && Operator.isCompatible(this.op, right) ? Operator.getBinaryOperator(this.op).apply(left, right) : null;
        }
    }

    private static class NumberExpr
    implements Expr {
        private final Double value;

        private NumberExpr(Double value) {
            this.value = value;
        }

        @Override
        public Object evaluate(Function<String, Object> evaluator) {
            return this.value;
        }
    }

    private static class Not
    implements Expr {
        private final Expr operand;

        private Not(Expr operand) {
            this.operand = operand;
        }

        @Override
        public Object evaluate(Function<String, Object> evaluator) {
            Object value = this.operand.evaluate(evaluator);
            return value instanceof Boolean ? Boolean.valueOf((Boolean)value == false) : null;
        }
    }

    private static class MatchedToken {
        private final int end;
        private final int token;
        private final int start;

        private MatchedToken(int token, Matcher matcher) {
            this.token = token;
            this.start = matcher.start(token);
            this.end = matcher.end(token);
        }
    }

    private static class Identifier
    implements Expr {
        private final String name;

        private Identifier(String name) {
            this.name = name;
        }

        @Override
        public Object evaluate(Function<String, Object> evaluator) {
            return evaluator.apply(this.name);
        }
    }

    public static interface Expr {
        public Object evaluate(Function<String, Object> var1);
    }
}

