/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import net.pincette.cls.ClassFile;
import net.pincette.cls.Field;
import net.pincette.cls.LocalVariable;
import net.pincette.cls.Method;
import net.pincette.function.SideEffect;
import net.pincette.io.StreamConnector;
import net.pincette.util.Collections;
import net.pincette.util.Pair;
import net.pincette.util.Util;

public class IsolatingClassLoader
extends ClassLoader {
    private static final Map<ClassLoader, Map<String, byte[]>> classesPerParent = new HashMap<ClassLoader, Map<String, byte[]>>();
    private static final String[] defaultPrefixes = new String[]{"int", "char", "void", "long", "short", "double", "byte", "float", "boolean", "java.", "javax."};
    private static final String[] excludePrefixes = new String[]{"javax.xml.stream.", "javax.xml.namespace."};
    private final File[] classPath;
    private final Map<String, Class<?>> loadedClasses = new HashMap();
    private final ClassLoader parent;
    private final Set<String> parentClasses = new HashSet<String>();
    private final String[] prefixesForParent;
    private final String[] prefixesNotForParent;

    public IsolatingClassLoader() {
        this(new String[0], null);
    }

    public IsolatingClassLoader(ClassLoader parent) {
        this(new String[0], parent);
    }

    public IsolatingClassLoader(String[] parentClasses) {
        this(parentClasses, null);
    }

    public IsolatingClassLoader(String[] parentClasses, ClassLoader parent) {
        this(parentClasses, new String[0], new String[0], parent);
    }

    public IsolatingClassLoader(String[] parentClasses, String[] prefixesForParent, String[] prefixesNotForParent, ClassLoader parent) {
        this(parentClasses, prefixesForParent, prefixesNotForParent, parent, new File[0]);
    }

    public IsolatingClassLoader(String[] parentClasses, String[] prefixesForParent, String[] prefixesNotForParent, ClassLoader parent, File[] classPath) {
        super(null);
        this.parent = parent != null ? parent : IsolatingClassLoader.getSystemClassLoader();
        this.prefixesForParent = new String[defaultPrefixes.length + prefixesForParent.length];
        this.prefixesNotForParent = new String[excludePrefixes.length + prefixesNotForParent.length];
        this.classPath = classPath;
        System.arraycopy(defaultPrefixes, 0, this.prefixesForParent, 0, defaultPrefixes.length);
        System.arraycopy(prefixesForParent, 0, this.prefixesForParent, defaultPrefixes.length, prefixesForParent.length);
        System.arraycopy(excludePrefixes, 0, this.prefixesNotForParent, 0, excludePrefixes.length);
        System.arraycopy(prefixesNotForParent, 0, this.prefixesNotForParent, excludePrefixes.length, prefixesNotForParent.length);
        Util.tryToDoRethrow(() -> this.inferClasses(parentClasses));
    }

    private static URL fromZip(String name, File classPathEntry) {
        return Util.tryToGetWith(() -> new ZipFile(classPathEntry), zip2 -> Optional.ofNullable(zip2.getEntry(name)).flatMap(e -> Util.tryToGetRethrow(() -> new URL("jar:" + classPathEntry.toURI() + "!/" + name))).orElse(null)).orElse(null);
    }

    private static boolean hasPrefix(String s, String[] prefixes) {
        return Arrays.stream(prefixes).anyMatch(s::startsWith);
    }

    private static boolean isJar(File classPathEntry) {
        return classPathEntry.isFile() && classPathEntry.getName().endsWith(".jar");
    }

    private static URL resourceUrl(String name, File classPathEntry) {
        Supplier<URL> fromDirectory = () -> classPathEntry.isDirectory() && new File(classPathEntry, name).exists() ? (URL)Util.tryToGetRethrow(() -> new File(classPathEntry, name).toURI().toURL()).orElse(null) : null;
        return IsolatingClassLoader.isJar(classPathEntry) ? IsolatingClassLoader.fromZip(name, classPathEntry) : fromDirectory.get();
    }

    private static void trace(String s) {
        Logger.getLogger("IsolatingClassLoader").finest(s);
    }

    private void definePackageWithName(String name) {
        Optional.of(name.lastIndexOf(46)).filter(index -> index != -1).map(index -> name.substring(0, (int)index)).filter(n -> this.getDefinedPackage((String)n) == null).ifPresent(n -> this.definePackage(name, null, null, null, null, null, null, null));
    }

    private byte[] loadFromResource(String name) {
        return Util.tryToGetRethrow(() -> this.getResourceAsStream(name.replace('.', '/') + ".class")).map(in -> Pair.pair(in, new ByteArrayOutputStream())).map(pair -> SideEffect.run(() -> Util.tryToDoRethrow(() -> StreamConnector.copy((InputStream)pair.first, (OutputStream)pair.second))).andThenGet(((ByteArrayOutputStream)pair.second)::toByteArray)).orElse(null);
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            return !this.isNotForParent(className) ? SideEffect.run(() -> IsolatingClassLoader.trace(className + ": parent classloader")).andThenGet(() -> Util.tryToGetRethrow(() -> this.parent.loadClass(className)).orElse(null)) : Collections.computeIfAbsent(this.loadedClasses, className, name -> Util.tryToGetRethrow(() -> this.loadClassAsResource((String)name)).orElse(null));
        }
        catch (Exception e) {
            throw e.getCause() instanceof ClassNotFoundException ? (ClassNotFoundException)e.getCause() : new ClassNotFoundException("", e);
        }
    }

    private InputStream getClassStream(String name) {
        return new ByteArrayInputStream(classesPerParent.computeIfAbsent(this.parent, p -> new HashMap()).computeIfAbsent(name, this::loadFromResource));
    }

    @Override
    public URL getResource(String name) {
        return Arrays.stream(this.classPath).map(cp -> IsolatingClassLoader.resourceUrl(name, cp)).filter(Objects::nonNull).map(url -> SideEffect.run(() -> IsolatingClassLoader.trace(name + ": " + url)).andThenGet(() -> url)).findFirst().orElse(SideEffect.run(() -> IsolatingClassLoader.trace(name + ": parent as resource")).andThenGet(() -> this.parent.getResource(name)));
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return Optional.ofNullable(this.getResource(name)).flatMap(r -> Util.tryToGetRethrow(r::openStream)).orElse(null);
    }

    private void inferClasses(String[] classes) {
        Arrays.stream(classes).map(c -> c.indexOf(91) != -1 ? c.substring(0, c.indexOf(91)) : c).filter(this::isNotForParent).map(name -> SideEffect.run(() -> this.parentClasses.add((String)name)).andThenGet(() -> name)).forEach(name -> Util.tryToGetWithRethrow(() -> this.getClassStream((String)name), ClassFile::parse).ifPresent(this::inferClasses));
    }

    private void inferClasses(ClassFile classFile) {
        if (classFile.getSuperClassType() != null) {
            this.inferClasses(new String[]{classFile.getSuperClassType()});
        }
        this.inferClasses(classFile.getInterfaceTypes());
        this.inferFieldClasses(classFile.getFields());
        this.inferMethodClasses(classFile.getMethods());
    }

    private void inferFieldClasses(Field[] fields) {
        Arrays.stream(fields).forEach(f -> this.inferClasses(new String[]{f.getType()}));
    }

    private void inferMethodClasses(Method[] methods) {
        Arrays.stream(methods).forEach(m -> {
            this.inferClasses(m.getExceptionTypes());
            this.inferClasses(m.getParameterTypes());
            this.inferClasses(new String[]{m.getReturnType()});
            if (m.getCode() != null) {
                this.inferVariableClasses(m.getCode().getLocalVariables());
            }
        });
    }

    private void inferVariableClasses(LocalVariable[] variables) {
        Arrays.stream(variables).forEach(v -> this.inferClasses(new String[]{v.getType()}));
    }

    private boolean isNotForParent(String className) {
        return !this.parentClasses.contains(className) && (!IsolatingClassLoader.hasPrefix(className, this.prefixesForParent) || IsolatingClassLoader.hasPrefix(className, this.prefixesNotForParent));
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findClass(name);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private Class<?> loadClassAsResource(String className) {
        this.definePackageWithName(className);
        return Optional.of(this.loadFromResource(className)).map(b -> this.defineClass(className, (byte[])b, 0, ((byte[])b).length)).orElse(null);
    }
}

