/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class MapBuilder<K, V> {
    private final Map<K, V> map;

    public MapBuilder(Map<? extends K, ? extends V> map) {
        this.map = new HashMap<K, V>(map);
    }

    public Map<K, V> build() {
        return this.map;
    }

    public MapBuilder<K, V> merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.map.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
        return this;
    }

    public MapBuilder<K, V> put(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    public MapBuilder<K, V> putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
        return this;
    }

    public MapBuilder<K, V> putIfAbsent(K key, V value) {
        this.map.putIfAbsent(key, value);
        return this;
    }

    public MapBuilder<K, V> remove(Object key) {
        this.map.remove(key);
        return this;
    }

    public MapBuilder<K, V> remove(Object key, Object value) {
        this.map.remove(key, value);
        return this;
    }

    public MapBuilder<K, V> replace(K key, V value) {
        this.map.replace(key, value);
        return this;
    }

    public MapBuilder<K, V> replace(K key, V oldValue, V newValue) {
        this.map.replace(key, oldValue, newValue);
        return this;
    }

    public MapBuilder<K, V> replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.map.replaceAll(function);
        return this;
    }
}

